<?php
/**
 * @name		Slider CK
 * @package		com_sliderck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.controlleradmin');

/**
 * Pages list controller class.
 */
class SliderckControllerStyles extends JControllerAdmin {

	/**
	 * Proxy for getModel.
	 * @since	1.6
	 */
	public function getModel($name = 'style', $prefix = 'SliderckModel', $config = array()) {
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));
		return $model;
	}

	public function import() {
		$app = JFactory::getApplication();
		if ($importClass = SliderckHelper::getParams('import')) {
			$importClass->importFile();
		} else {
			$msg = JText::_('CK_SLIDERCK_PARAMS_NOT_FOUND');
			$app->redirect("index.php?option=com_sliderck&view=pages", $msg, 'error');
			return false;
		}
	}

	public function export() {
		$app = JFactory::getApplication();
		if ($exportClass = SliderckHelper::getParams('export')) {
			$exportClass->exportFile();
		} else {
			$msg = JText::_('CK_SLIDERCK_PARAMS_NOT_FOUND');
			$app->redirect("index.php?option=com_sliderck&view=pages", $msg, 'error');
			return false;
		}
	}

//	public function publish() {
//		die('test');
//	}
	
}