<?php
/**
 * @name		Slider CK
 * @package		com_sliderck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */
 
defined('_JEXEC') or die('Restricted access');
/*
	preflight which is executed before install and update
	install
	update
	uninstall
	postflight which is executed after install and update
	*/

class com_sliderckInstallerScript {

	function install($parent) {
		
	}
	
	function update($parent) {
		
	}
	
	function uninstall($parent) {
		jimport('joomla.installer.installer');
		$db = JFactory::getDbo();
		// Check first that the module exist
		$db->setQuery('SELECT `extension_id` FROM #__extensions WHERE `element` = "mod_sliderck" AND `type` = "module"');
		$id = $db->loadResult();
		// var_dump($id);
		// die;
		if($id)
		{
			$installer = new JInstaller;
			$result = $installer->uninstall('module', $id);
		}
	}

	function preflight($type, $parent) {
		return true;
	}

	// run on install and update
	function postflight($type, $parent) {
		// install modules and plugins
		jimport('joomla.installer.installer');
		$db = JFactory::getDbo();
		$status = array();
		$src_ext = dirname(__FILE__).'/administrator/extensions';
		$installer = new JInstaller;
/*
		// extensions to install
		// system plugin
		$result = $installer->install($src_ext.'/system_sliderck');
		$status[] = array('name'=>'System - Slider CK','type'=>'plugin', 'result'=>$result);
		// system plugin must be enabled for user group limits and private areas
		$db->setQuery("UPDATE #__extensions SET enabled = '1' WHERE `element` = 'sliderck' AND `type` = 'plugin'");
		$db->query();

		// editor button plugin
		$result = $installer->install($src_ext.'/sliderckbutton');
		$status[] = array('name'=>'Button - Slider CK','type'=>'plugin', 'result'=>$result);
		// auto enable the plugin
		$db->setQuery("UPDATE #__extensions SET enabled = '1' WHERE `element` = 'sliderckbutton' AND `type` = 'plugin'");
		$db->query();

		// editor plugin (editor button type)
		$result = $installer->install($src_ext.'/sliderckeditor');
		$status[] = array('name'=>'Editor - Slider CK','type'=>'plugin', 'result'=>$result);
		// auto enable the plugin
		$db->setQuery("UPDATE #__extensions SET enabled = '1' WHERE `element` = 'sliderckeditor' AND `type` = 'plugin'");
		$db->query();

		// search plugin
		$result = $installer->install($src_ext.'/slidercksearch');
		$status[] = array('name'=>'Search - Slider CK','type'=>'plugin', 'result'=>$result);
		// auto enable the plugin
		$db->setQuery("UPDATE #__extensions SET enabled = '1' WHERE `element` = 'slidercksearch' AND `type` = 'plugin'");
		$db->query();
*/
		// module
		$result = $installer->install($src_ext.'/mod_sliderck');
		$status[] = array('name'=>'Slider CK - Module','type'=>'module', 'result'=>$result);
		// auto enable the plugin
		// $db->setQuery("UPDATE #__extensions SET enabled = '1' WHERE `element` = 'mod_sliderck' AND `type` = 'module'");
		// $db->query();

		foreach ($status as $statu) {
			if ($statu['result'] == true) {
				$alert = 'success';
				$icon = 'icon-ok';
				$text = 'Successful';
			} else {
				$alert = 'warning';
				$icon = 'icon-cancel';
				$text = 'Failed';
			}
			echo '<div class="alert alert-' . $alert . '"><i class="icon ' . $icon . '"></i>Installation and activation of the <b>' . $statu['type'] . ' ' . $statu['name'] . '</b> : ' . $text . '</div>';
		}

		return true;
	}
}
