<?php
/**
 * @name		Slider CK
 * @package		com_sliderck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */
 
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');

/**
 * View class for a list of Maximenuck.
 */
class SliderckViewModules extends JViewLegacy {

	protected $items;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->items = $this->getModules();

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		require_once JPATH_COMPONENT . '/helpers/sliderck.php';

		// Load the left sidebar.
		SliderckHelper::addSubmenu(JRequest::getCmd('view', 'modules'));
		// Load the title
		JToolBarHelper::title(JText::_('COM_SLIDERCK') . ' - ' . JText::_('CK_MODULES_LIST'), 'logo_sliderck_large.png');

		parent::display($tpl);
	}

	/**
	 * Get the list of sliderck modules
	 */
	private function getModules() {
		// Create a new query object.
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select('a.id, a.title, a.published, a.position, a.params');
		$query->from($db->quoteName('#__modules') . ' AS a');
		$query->where('(a.published IN (0, 1))');
		$query->where('a.module = ' . $db->quote('mod_sliderck'));

		// Reset the query using our newly populated query object.
		$db->setQuery($query);

		// Load the results as a list of stdClass objects (see later for more options on retrieving data).
		$results = $db->loadObjectList();

		return $results;
	}
}
