/**ABDB**/CREATE TABLE `#__workflows` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_extension` (`extension`),
  KEY `idx_default` (`default`),
  KEY `idx_created` (`created`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_modified` (`modified`),
  KEY `idx_modified_by` (`modified_by`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflows`  VALUES 
('1', '0', '1', 'COM_WORKFLOW_BASIC_WORKFLOW', '', 'com_content.article', '1', '1', '2021-09-20 06:36:55', '0', '2021-09-20 06:36:55', '0', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_transitions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_stage_id` int(11) NOT NULL,
  `to_stage_id` int(11) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_from_stage_id` (`from_stage_id`),
  KEY `idx_to_stage_id` (`to_stage_id`),
  KEY `idx_workflow_id` (`workflow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_transitions`  VALUES 
('1', '0', '1', '1', '1', 'UNPUBLISH', '', '-1', '1', '{\"publishing\":\"0\"}', NULL, NULL),
('2', '0', '2', '1', '1', 'PUBLISH', '', '-1', '1', '{\"publishing\":\"1\"}', NULL, NULL),
('3', '0', '3', '1', '1', 'TRASH', '', '-1', '1', '{\"publishing\":\"-2\"}', NULL, NULL),
('4', '0', '4', '1', '1', 'ARCHIVE', '', '-1', '1', '{\"publishing\":\"2\"}', NULL, NULL),
('5', '0', '5', '1', '1', 'FEATURE', '', '-1', '1', '{\"featuring\":\"1\"}', NULL, NULL),
('6', '0', '6', '1', '1', 'UNFEATURE', '', '-1', '1', '{\"featuring\":\"0\"}', NULL, NULL),
('7', '0', '7', '1', '1', 'PUBLISH_AND_FEATURE', '', '-1', '1', '{\"publishing\":\"1\",\"featuring\":\"1\"}', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_stages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_workflow_id` (`workflow_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_default` (`default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_stages`  VALUES 
('1', '0', '1', '1', '1', 'COM_WORKFLOW_BASIC_STAGE', '', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_associations` (
  `item_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Extension table id value',
  `stage_id` int(11) NOT NULL COMMENT 'Foreign Key to #__workflow_stages.id',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`,`extension`),
  KEY `idx_item_stage_extension` (`item_id`,`stage_id`,`extension`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_stage_id` (`stage_id`),
  KEY `idx_extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_associations`  VALUES 
('1', '1', 'com_content.article'),
('3', '1', 'com_content.article'),
('4', '1', 'com_content.article'),
('5', '1', 'com_content.article'),
('6', '1', 'com_content.article'),
('7', '1', 'com_content.article'),
('12', '1', 'com_content.article'),
('13', '1', 'com_content.article'),
('15', '1', 'com_content.article'),
('16', '1', 'com_content.article'),
('17', '1', 'com_content.article'),
('18', '1', 'com_content.article'),
('49', '1', 'com_content.article'),
('52', '1', 'com_content.article'),
('53', '1', 'com_content.article'),
('54', '1', 'com_content.article'),
('55', '1', 'com_content.article'),
('56', '1', 'com_content.article'),
('57', '1', 'com_content.article'),
('58', '1', 'com_content.article'),
('59', '1', 'com_content.article'),
('60', '1', 'com_content.article');
/**ABDB**/CREATE TABLE `#__webauthn_credentials` (
  `id` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential ID',
  `user_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'User handle',
  `label` varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Human readable label',
  `credential` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential source data, JSON format',
  PRIMARY KEY (`id`(100)),
  KEY `user_id` (`user_id`(60))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '2', '[6,2,8]'),
('3', 'Special', '3', '[6,3,8]'),
('5', 'Guest', '1', '[9]'),
('6', 'Super Users', '4', '[8]');
/**ABDB**/CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT 0,
  `sendEmail` tinyint(4) DEFAULT 0,
  `registerDate` datetime NOT NULL,
  `lastvisitDate` datetime DEFAULT NULL,
  `activation` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastResetTime` datetime DEFAULT NULL,
  `resetCount` int(11) NOT NULL DEFAULT 0 COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Require user to reset password on next login',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_name` (`name`(100)),
  KEY `idx_block` (`block`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=778 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('777', 'Victoria Rawson', 'admin', 'admin@localhost', '$2y$10$Ujl7Oy7WfdUAr1uGgIZDGuhDifP0IN3Xpi9DUQBL8MsOcTqaO/EBS', '0', '1', '2020-08-21 07:54:09', '2021-12-06 09:09:40', '0', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"astroid_author_picture\":\"gravatar\",\"upload\":\"\",\"astroid_author_aboutme\":\"Hello! I am Victoria. I\'m a creative designer and developer at TemPlaza. I enjoy creating eye candy solutions for web and mobile applications. I\'d love to work on yours, too :)\",\"astroid_author_social\":[]}', NULL, '0', '', '', '0');
/**ABDB**/CREATE TABLE `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__usergroups`  VALUES 
('1', '0', '1', '18', 'Public'),
('2', '1', '8', '15', 'Registered'),
('3', '2', '9', '14', 'Author'),
('4', '3', '10', '13', 'Editor'),
('5', '4', '11', '12', 'Publisher'),
('6', '1', '4', '7', 'Manager'),
('7', '6', '5', '6', 'Administrator'),
('8', '1', '16', '17', 'Super Users'),
('9', '1', '2', '3', 'Guest');
/**ABDB**/CREATE TABLE `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__user_usergroup_map`  VALUES 
('777', '8');
/**ABDB**/CREATE TABLE `#__user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `review_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `series` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uastring` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT 0,
  `extension_id` int(11) DEFAULT 0,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint(3) DEFAULT 0,
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `#__updates`  VALUES 
('1', '2', '0', 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', '0', '4.0.2.1', '', 'https://update.joomla.org/language/details4/ar-AA_details.xml', '', '', ''),
('2', '2', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '4.0.4.2', '', 'https://update.joomla.org/language/details4/ca-ES_details.xml', '', '', ''),
('3', '2', '0', 'Chinese, Simplified', '', 'pkg_zh-CN', 'package', '', '0', '4.0.3.3', '', 'https://update.joomla.org/language/details4/zh-CN_details.xml', '', '', ''),
('4', '2', '0', 'Chinese, Traditional', '', 'pkg_zh-TW', 'package', '', '0', '4.0.4.2', '', 'https://update.joomla.org/language/details4/zh-TW_details.xml', '', '', ''),
('5', '2', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '4.0.3.1', '', 'https://update.joomla.org/language/details4/cs-CZ_details.xml', '', '', ''),
('6', '2', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/da-DK_details.xml', '', '', ''),
('7', '2', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/nl-NL_details.xml', '', '', ''),
('8', '2', '0', 'English, Australia', '', 'pkg_en-AU', 'package', '', '0', '4.0.4.3', '', 'https://update.joomla.org/language/details4/en-AU_details.xml', '', '', ''),
('9', '2', '0', 'English, Canada', '', 'pkg_en-CA', 'package', '', '0', '4.0.4.4', '', 'https://update.joomla.org/language/details4/en-CA_details.xml', '', '', ''),
('10', '2', '0', 'English, New Zealand', '', 'pkg_en-NZ', 'package', '', '0', '4.0.4.3', '', 'https://update.joomla.org/language/details4/en-NZ_details.xml', '', '', ''),
('11', '2', '0', 'English, USA', '', 'pkg_en-US', 'package', '', '0', '4.0.4.3', '', 'https://update.joomla.org/language/details4/en-US_details.xml', '', '', ''),
('12', '2', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/fi-FI_details.xml', '', '', ''),
('13', '2', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/nl-BE_details.xml', '', '', ''),
('14', '2', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/fr-FR_details.xml', '', '', ''),
('15', '2', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/ka-GE_details.xml', '', '', ''),
('16', '2', '0', 'German', '', 'pkg_de-DE', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/de-DE_details.xml', '', '', ''),
('17', '2', '0', 'German, Austria', '', 'pkg_de-AT', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/de-AT_details.xml', '', '', ''),
('18', '2', '0', 'German, Liechtenstein', '', 'pkg_de-LI', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/de-LI_details.xml', '', '', ''),
('19', '2', '0', 'German, Luxembourg', '', 'pkg_de-LU', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/de-LU_details.xml', '', '', ''),
('20', '2', '0', 'German, Switzerland', '', 'pkg_de-CH', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/de-CH_details.xml', '', '', ''),
('21', '2', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/el-GR_details.xml', '', '', ''),
('22', '2', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '4.0.3.1', '', 'https://update.joomla.org/language/details4/hu-HU_details.xml', '', '', ''),
('23', '2', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/it-IT_details.xml', '', '', ''),
('24', '2', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/ja-JP_details.xml', '', '', ''),
('25', '2', '0', 'Norwegian Bokmål', '', 'pkg_nb-NO', 'package', '', '0', '4.0.1.1', '', 'https://update.joomla.org/language/details4/nb-NO_details.xml', '', '', ''),
('26', '2', '0', 'Persian Farsi', '', 'pkg_fa-IR', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/fa-IR_details.xml', '', '', ''),
('27', '2', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/pl-PL_details.xml', '', '', ''),
('28', '2', '0', 'Portuguese, Brazil', '', 'pkg_pt-BR', 'package', '', '0', '4.0.3.1', '', 'https://update.joomla.org/language/details4/pt-BR_details.xml', '', '', ''),
('29', '2', '0', 'Portuguese, Portugal', '', 'pkg_pt-PT', 'package', '', '0', '4.0.0-rc4.2', '', 'https://update.joomla.org/language/details4/pt-PT_details.xml', '', '', ''),
('30', '2', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '4.0.3.1', '', 'https://update.joomla.org/language/details4/ro-RO_details.xml', '', '', ''),
('31', '2', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/ru-RU_details.xml', '', '', ''),
('32', '2', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/sk-SK_details.xml', '', '', ''),
('33', '2', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/sl-SI_details.xml', '', '', ''),
('34', '2', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/es-ES_details.xml', '', '', ''),
('35', '2', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/sv-SE_details.xml', '', '', ''),
('36', '2', '0', 'Tamil, India', '', 'pkg_ta-IN', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/ta-IN_details.xml', '', '', ''),
('37', '2', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/th-TH_details.xml', '', '', ''),
('38', '2', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '4.0.4.2', '', 'https://update.joomla.org/language/details4/tr-TR_details.xml', '', '', ''),
('39', '2', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '4.0.3.2', '', 'https://update.joomla.org/language/details4/uk-UA_details.xml', '', '', ''),
('40', '2', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '4.0.4.1', '', 'https://update.joomla.org/language/details4/cy-GB_details.xml', '', '', ''),
('41', '9', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/af-ZA_details.xml', '', '', ''),
('42', '9', '0', 'Albanian', '', 'pkg_sq-AL', 'package', '', '0', '3.1.1.2', '', 'https://update.joomla.org/language/details3/sq-AL_details.xml', '', '', ''),
('43', '9', '0', 'Armenian', '', 'pkg_hy-AM', 'package', '', '0', '3.4.4.1', '', 'https://update.joomla.org/language/details3/hy-AM_details.xml', '', '', ''),
('44', '9', '0', 'Basque', '', 'pkg_eu-ES', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/eu-ES_details.xml', '', '', ''),
('45', '9', '0', 'Belarusian', '', 'pkg_be-BY', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/be-BY_details.xml', '', '', ''),
('46', '9', '0', 'Bengali, Bangladesh', '', 'pkg_bn-BD', 'package', '', '0', '3.8.10.1', '', 'https://update.joomla.org/language/details3/bn-BD_details.xml', '', '', ''),
('47', '9', '0', 'Bosnian', '', 'pkg_bs-BA', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/bs-BA_details.xml', '', '', ''),
('48', '9', '0', 'Bulgarian', '', 'pkg_bg-BG', 'package', '', '0', '3.6.5.2', '', 'https://update.joomla.org/language/details3/bg-BG_details.xml', '', '', ''),
('49', '9', '0', 'Croatian', '', 'pkg_hr-HR', 'package', '', '0', '3.10.3.1', '', 'https://update.joomla.org/language/details3/hr-HR_details.xml', '', '', ''),
('50', '9', '0', 'Dari Persian', '', 'pkg_prs-AF', 'package', '', '0', '3.4.4.3', '', 'https://update.joomla.org/language/details3/prs-AF_details.xml', '', '', ''),
('51', '9', '0', 'Dzongkha', '', 'pkg_dz-BT', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/dz-BT_details.xml', '', '', ''),
('52', '9', '0', 'Esperanto', '', 'pkg_eo-XX', 'package', '', '0', '3.8.11.1', '', 'https://update.joomla.org/language/details3/eo-XX_details.xml', '', '', ''),
('53', '9', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '3.9.21.1', '', 'https://update.joomla.org/language/details3/et-EE_details.xml', '', '', ''),
('54', '9', '0', 'French, Canada', '', 'pkg_fr-CA', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/fr-CA_details.xml', '', '', ''),
('55', '9', '0', 'Galician', '', 'pkg_gl-ES', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/gl-ES_details.xml', '', '', ''),
('56', '9', '0', 'Hindi, India', '', 'pkg_hi-IN', 'package', '', '0', '3.3.6.2', '', 'https://update.joomla.org/language/details3/hi-IN_details.xml', '', '', ''),
('57', '9', '0', 'Indonesian, Bahasa Indonesia', '', 'pkg_id-ID', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/id-ID_details.xml', '', '', ''),
('58', '9', '0', 'Irish', '', 'pkg_ga-IE', 'package', '', '0', '3.8.13.1', '', 'https://update.joomla.org/language/details3/ga-IE_details.xml', '', '', ''),
('59', '9', '0', 'Kazakh', '', 'pkg_kk-KZ)', 'package', '', '0', '3.9.23.1', '', 'https://update.joomla.org/language/details3/kk-KZ)_details.xml', '', '', ''),
('60', '9', '0', 'Khmer', '', 'pkg_km-KH', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/km-KH_details.xml', '', '', ''),
('61', '9', '0', 'Korean', '', 'pkg_ko-KR', 'package', '', '0', '3.8.9.1', '', 'https://update.joomla.org/language/details3/ko-KR_details.xml', '', '', ''),
('62', '9', '0', 'Latvian', '', 'pkg_lv-LV', 'package', '', '0', '3.9.25.2', '', 'https://update.joomla.org/language/details3/lv-LV_details.xml', '', '', ''),
('63', '9', '0', 'Lithuanian', '', 'pkg_lt-LT', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/lt-LT_details.xml', '', '', ''),
('64', '9', '0', 'Macedonian', '', 'pkg_mk-MK', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/mk-MK_details.xml', '', '', ''),
('65', '9', '0', 'Malay', '', 'pkg_ms-MY', 'package', '', '0', '3.4.1.2', '', 'https://update.joomla.org/language/details3/ms-MY_details.xml', '', '', ''),
('66', '9', '0', 'Montenegrin', '', 'pkg_srp-ME', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/srp-ME_details.xml', '', '', ''),
('67', '9', '0', 'Norwegian Nynorsk', '', 'pkg_nn-NO', 'package', '', '0', '3.4.2.1', '', 'https://update.joomla.org/language/details3/nn-NO_details.xml', '', '', ''),
('68', '9', '0', 'Serbian, Cyrillic', '', 'pkg_sr-RS', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/sr-RS_details.xml', '', '', ''),
('69', '9', '0', 'Serbian, Latin', '', 'pkg_sr-YU', 'package', '', '0', '3.10.2.1', '', 'https://update.joomla.org/language/details3/sr-YU_details.xml', '', '', ''),
('70', '9', '0', 'Sinhala', '', 'pkg_si-LK', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/si-LK_details.xml', '', '', ''),
('71', '9', '0', 'Spanish, Colombia', '', 'pkg_es-CO', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/es-CO_details.xml', '', '', ''),
('72', '9', '0', 'Swahili', '', 'pkg_sw-KE', 'package', '', '0', '3.10.3.3', '', 'https://update.joomla.org/language/details3/sw-KE_details.xml', '', '', ''),
('73', '9', '0', 'Syriac, East', '', 'pkg_sy-IQ', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/sy-IQ_details.xml', '', '', ''),
('74', '9', '0', 'Turkmen', '', 'pkg_tk-TM', 'package', '', '0', '3.5.0.2', '', 'https://update.joomla.org/language/details3/tk-TM_details.xml', '', '', ''),
('75', '9', '0', 'Uyghur', '', 'pkg_ug-CN', 'package', '', '0', '3.7.5.2', '', 'https://update.joomla.org/language/details3/ug-CN_details.xml', '', '', ''),
('76', '9', '0', 'Vietnamese', '', 'pkg_vi-VN', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/vi-VN_details.xml', '', '', '');
/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT 0,
  `extension_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '700'),
('2', '802'),
('3', '28'),
('4', '10001'),
('6', '10003'),
('9', '10008'),
('10', '10008'),
('14', '10012'),
('15', '10023'),
('16', '10028'),
('17', '10036'),
('32', '10059'),
('44', '10126'),
('45', '10129'),
('56', '10140'),
('58', '10142');
/**ABDB**/CREATE TABLE `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) DEFAULT 0,
  `last_check_timestamp` bigint(20) DEFAULT 0,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `#__update_sites`  VALUES 
('1', 'Joomla! Core', 'collection', 'https://update.joomla.org/core/list.xml', '1', '1638781785', '', NULL, NULL),
('2', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_4.xml', '1', '1638781787', '', NULL, NULL),
('3', 'Joomla! Update Component Update Site', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1638781788', '', NULL, NULL),
('4', 'Jollyany Plugin', 'extension', 'https://www.templaza.com/tzupdates/jollyany.xml', '1', '1638781788', '', NULL, NULL),
('6', 'astroid_framework', 'extension', 'https://cdn.joomdev.com/updates/astroid_system_plugin.xml', '1', '1638781790', '', NULL, NULL),
('9', 'Accredited Joomla! Translations', 'collection', 'http://update.joomla.org/language/translationlist_3.xml', '1', '1638781791', '', NULL, NULL),
('10', 'Accredited Joomla! Translations', 'collection', 'http://www.joomla.org.il/translationlist_3.xml', '1', '1638781792', '', NULL, NULL),
('14', 'SP Page Builder', 'extension', 'https://www.joomshaper.com/updates/com-sp-page-builder-pro.xml', '1', '1638781793', '', NULL, NULL),
('15', 'AcyMailing', 'extension', 'https://www.acyba.com/index.php?option=com_updateme&nocache=1638781818&ctrl=updatexml&version=7.7.0&component=acymailing&cms=joomla&level=starter', '1', '1638781795', '', NULL, NULL),
('16', 'TZ Portfolio Plus Component', 'extension', 'http://www.tzportfolio.com/tzupdates/tz_portfolio_plus.xml', '1', '1638781796', '', NULL, NULL),
('17', 'FOF 3.x', 'extension', 'http://cdn.akeeba.com/updates/fof3_file.xml', '1', '1638781796', '', NULL, NULL),
('32', 'Logistics Template', 'extension', 'https://www.templaza.com/tzupdates/tz_logistics_template.xml', '0', '0', '', NULL, NULL),
('44', 'Search Update Site', 'extension', 'https://raw.githubusercontent.com/joomla-extensions/search/main/manifest.xml', '1', '1638781796', '', NULL, NULL),
('45', 'Akeeba Backup Core for Joomla!', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', '1', '1638781797', '', NULL, NULL),
('56', 'Astroid Framework', 'extension', 'https://raw.githubusercontent.com/templaza/astroid-framework/master/astroid_framework.xml', '1', '0', '', NULL, NULL),
('58', 'Jollyany Framework', 'extension', 'https://raw.githubusercontent.com/templaza/jollyany/master/jollyany_framework.xml', '1', '0', '', NULL, NULL);
/**ABDB**/CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT 0,
  `core_checked_out_time` datetime DEFAULT NULL,
  `core_checked_out_user_id` int(10) unsigned DEFAULT NULL,
  `core_access` int(10) unsigned NOT NULL DEFAULT 0,
  `core_params` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `core_metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `core_created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL,
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL,
  `core_language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime DEFAULT NULL,
  `core_publish_down` datetime DEFAULT NULL,
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `core_images` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_urls` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT 0,
  `core_version` int(10) unsigned NOT NULL DEFAULT 1,
  `core_ordering` int(11) NOT NULL DEFAULT 0,
  `core_metakey` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_metadesc` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT 0,
  `core_xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`(100)),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';
/**ABDB**/CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template` varchar(100) NOT NULL,
  `title` varchar(255) NOT NULL,
  `home` char(7) NOT NULL DEFAULT '0',
  `protected` tinyint(3) NOT NULL DEFAULT 0,
  `layout` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  `preset` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_templates`  VALUES 
('1', 'elegant', 'elegant - Default', '0', '1', '', '{\"use_single_layout_builder\":\"0\",\"load_style\":\"1\"}', ''),
('2', 'system', 'system - Default', '0', '1', '', '', ''),
('3', 'besley', 'besley - Default', '1', '0', '[{\"name\":\"Media\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"\",\"col-sm\":\"\",\"col-md\":\"\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"media\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Title\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"0 0 20px\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"\",\"col-sm\":\"\",\"col-md\":\"\",\"col-lg\":\"10\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"title\",\"customclass\":\"\",\"responsiveclass\":\"\"},{\"col-xs\":\"\",\"col-sm\":\"\",\"col-md\":\"\",\"col-lg\":\"2\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"icons\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Information\",\"class\":\"inline-style muted\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"0 0 20px\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"created_date\",\"customclass\":\"\",\"responsiveclass\":\"\"},{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"author\",\"customclass\":\"\",\"responsiveclass\":\"\"},{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"category\",\"customclass\":\"\",\"responsiveclass\":\"\"},{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"hits\",\"customclass\":\"\",\"responsiveclass\":\"\"},{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"comment:count\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Introtext\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"introtext\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Fulltext\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"fulltext\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Password\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"password\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Extra Fields\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"extrafields\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Project Link\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"15px 0 0\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"project_link\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Vote\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"15px 0 0\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"vote\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Social\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"15px 0 0\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"social\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Tags\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"15px 0 0\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"tags\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Author Info\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"15px 0 0\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"author_about\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Related Articles\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"related\",\"customclass\":\"\",\"responsiveclass\":\"\"}]}]', '{\"layout\":\"default\",\"use_single_layout_builder\":\"1\",\"date_format\":\"l, d F Y H:i\",\"load_style\":\"1\",\"ratio\":\"5:3\",\"bgcolor\":\"rgba(0, 0, 0, 0.5)\",\"textcolor\":\"rgba(255, 255, 255, 1)\"}', '');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `description` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_tags`  VALUES 
('9', 'Outsourcing', 'outsourcing', '1', NULL, NULL),
('10', 'Vendor management', 'vendor-management', '1', NULL, NULL),
('11', 'Consulting', 'consulting', '1', NULL, NULL),
('12', 'Invoice Control', 'invoice-control', '1', NULL, NULL),
('13', 'Transportation', 'transportation', '1', NULL, NULL),
('14', 'Vehicle Management', 'vehicle-management', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_tag_content_map` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tagsid` int(11) NOT NULL DEFAULT 0,
  `contentid` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_tag_content_map`  VALUES 
('30', '9', '9'),
('31', '9', '8'),
('32', '10', '8'),
('33', '10', '2'),
('34', '11', '2'),
('35', '11', '5'),
('36', '12', '5'),
('37', '13', '3'),
('38', '14', '3'),
('39', '10', '6'),
('40', '13', '6'),
('41', '14', '6'),
('42', '9', '4'),
('43', '10', '4'),
('44', '12', '4'),
('45', '14', '8');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `value` text DEFAULT NULL,
  `default_value` text DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `advanced_search` tinyint(4) NOT NULL DEFAULT 0,
  `list_view` tinyint(4) NOT NULL DEFAULT 0,
  `detail_view` tinyint(4) NOT NULL DEFAULT 1,
  `params` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 1,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 1,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_fieldgroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `name` varchar(255) NOT NULL DEFAULT '',
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `field_ordering_type` tinyint(4) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `access` int(10) unsigned NOT NULL DEFAULT 1,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_field_fieldgroup_map` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldsid` int(11) NOT NULL DEFAULT 0,
  `groupid` int(11) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_field_content_map` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contentid` int(11) NOT NULL DEFAULT 0,
  `fieldsid` int(11) NOT NULL DEFAULT 0,
  `value` text DEFAULT NULL,
  `images` text DEFAULT NULL,
  `imagetitle` varchar(255) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_extensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `type` varchar(100) NOT NULL DEFAULT '',
  `element` varchar(100) NOT NULL DEFAULT '',
  `folder` varchar(100) NOT NULL DEFAULT '',
  `protected` tinyint(3) NOT NULL DEFAULT 0,
  `manifest_cache` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `access` int(10) NOT NULL DEFAULT 1,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_extensions`  VALUES 
('1', 'system', 'tz_portfolio_plus-template', 'system', '', '1', '{\"name\":\"system\",\"type\":\"tz_portfolio_plus-template\",\"creationDate\":\"July 17th 2015\",\"author\":\"DuongTVTemplaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"info@templaza.com\",\"authorUrl\":\"www.templaza.com\",\"version\":\"1.3\",\"description\":\"TZ_PORTFOLIO_PLUS_TPL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"template\"}', '', '0', '0000-00-00 00:00:00', '1', '1', '0', '0'),
('2', 'plg_content_vote', 'tz_portfolio_plus-plugin', 'vote', 'content', '1', '{\"name\":\"plg_content_vote\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"Aug, 09th 2012\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\",\"version\":\"2.5.3\",\"description\":\"PLG_CONTENT_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}', '{\"show_cat_vote\":\"0\",\"show_cat_counter\":\"1\",\"cat_unrated\":\"1\",\"show_counter\":\"1\",\"unrated\":\"1\"}', '0', '2016-01-07 10:03:01', '1', '1', '0', '164'),
('3', 'plg_mediatype_image', 'tz_portfolio_plus-plugin', 'image', 'mediatype', '1', '{\"name\":\"plg_mediatype_image\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"May 4th 2021\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2021 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.5.3\",\"description\":\"PLG_MEDIATYPE_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}', '{\"image_file_size\":\"10\",\"image_file_type\":\"bmp,gif,jpg,jpeg,png,BMP,GIF,JPG,JPEG,PNG\",\"image_mime_type\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp\",\"image_size\":[\"{\\\"title\\\":\\\"XSmall\\\",\\\"width\\\":\\\"100\\\",\\\"image_name_prefix\\\":\\\"xs\\\"}\",\"{\\\"title\\\":\\\"Small\\\",\\\"width\\\":\\\"200\\\",\\\"image_name_prefix\\\":\\\"s\\\"}\",\"{\\\"title\\\":\\\"Medium\\\",\\\"width\\\":\\\"400\\\",\\\"image_name_prefix\\\":\\\"m\\\"}\",\"{\\\"title\\\":\\\"Large\\\",\\\"width\\\":\\\"600\\\",\\\"image_name_prefix\\\":\\\"l\\\"}\",\"{\\\"title\\\":\\\"XLarge\\\",\\\"width\\\":\\\"900\\\",\\\"image_name_prefix\\\":\\\"xl\\\"}\"],\"mt_image_show_feed_image\":\"1\",\"mt_image_feed_size\":\"o\",\"mt_show_cat_image_hover\":\"1\",\"mt_cat_image_size\":\"o\",\"mt_image_size\":\"o\",\"mt_show_image_hover\":\"1\",\"mt_image_use_cloud\":\"0\",\"mt_image_related_show_image\":\"1\",\"mt_image_related_size\":\"o\",\"mt_image_cloud_size\":\"o\",\"mt_image_cloud_position\":\"inside\",\"mt_image_cloud_softfocus\":\"0\",\"mt_image_cloud_show_title\":\"1\",\"mt_image_cloud_width\":\"\",\"mt_image_cloud_height\":\"\",\"mt_image_cloud_adjustX\":\"0\",\"mt_image_cloud_adjustY\":\"0\",\"mt_image_cloud_tint\":\"\",\"mt_image_cloud_tint_opacity\":\"0.5\",\"mt_image_cloud_len_opacity\":\"0.5\",\"mt_image_cloud_smoothmove\":\"3\",\"mt_image_cloud_title_opacity\":\"0.5\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '171'),
('4', 'plg_extrafields_text', 'tz_portfolio_plus-plugin', 'text', 'extrafields', '1', '{\"name\":\"plg_extrafields_text\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"October 20th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.5.3\",\"description\":\"PLG_EXTRAFIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}', '{\"suggestion\":\"0\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '169'),
('5', 'plg_extrafields_textarea', 'tz_portfolio_plus-plugin', 'textarea', 'extrafields', '1', '{\"name\":\"plg_extrafields_textarea\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"October 20th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.5.3\",\"description\":\"PLG_EXTRAFIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}', '{\"cols\":\"50\",\"rows\":\"5\",\"use_editor_back_end\":\"0\",\"use_editor_front_end\":\"0\",\"groups_can_use_frontend_editor\":\"1\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '170'),
('6', 'plg_extrafields_checkboxes', 'tz_portfolio_plus-plugin', 'checkboxes', 'extrafields', '1', '{\"name\":\"plg_extrafields_checkboxes\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"October 20th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.5.3\",\"description\":\"PLG_EXTRAFIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}', '{\"number_columns\":\"0\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '165'),
('7', 'plg_extrafields_dropdownlist', 'tz_portfolio_plus-plugin', 'dropdownlist', 'extrafields', '1', '{\"name\":\"plg_extrafields_dropdownlist\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"October 20th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.5.3\",\"description\":\"PLG_EXTRAFIELDS_DROPDOWNLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"dropdownlist\"}', '{\"size\":\"5\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '166'),
('8', 'plg_extrafields_multipleselect', 'tz_portfolio_plus-plugin', 'multipleselect', 'extrafields', '1', '{\"name\":\"plg_extrafields_multipleselect\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"October 20th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.5.3\",\"description\":\"PLG_EXTRAFIELDS_MULTIPLESELECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"multipleselect\"}', '{\"size\":\"5\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '167'),
('9', 'plg_extrafields_radio', 'tz_portfolio_plus-plugin', 'radio', 'extrafields', '1', '{\"name\":\"plg_extrafields_radio\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"October 20th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.5.3\",\"description\":\"PLG_EXTRAFIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}', '{\"bootstrap_style\":\"1\",\"number_columns\":\"0\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '168'),
('10', 'plg_user_profile', 'tz_portfolio_plus-plugin', 'profile', 'user', '1', '{\"name\":\"plg_user_profile\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"December 13th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.5.3\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}', '{}', '0', '0000-00-00 00:00:00', '1', '1', '0', '172'),
('11', 'elegant', 'tz_portfolio_plus-template', 'elegant', '', '1', '{\"name\":\"elegant\",\"type\":\"tz_portfolio_plus-template\",\"creationDate\":\"September 5th 2019\",\"author\":\"Sonny\",\"copyright\":\"Copyright (C) 2019 TemPlaza. All rights reserved.\",\"authorEmail\":\"sonlv@templaza.com\",\"authorUrl\":\"www.templaza.com\",\"version\":\"2.9\",\"description\":\"TZ_PORTFOLIO_PLUS_TPL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"template\"}', '{\"use_single_layout_builder\":\"0\",\"load_style\":\"1\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '0'),
('20', 'besley', 'tz_portfolio_plus-template', 'besley', '', '0', '{\"name\":\"besley\",\"type\":\"tz_portfolio_plus-template\",\"creationDate\":\"September 2021\",\"author\":\"Sonny\",\"copyright\":\"Copyright (C) 2018 TemPlaza. All rights reserved.\",\"authorEmail\":\"sonlv@templaza.com\",\"authorUrl\":\"www.templaza.com\",\"version\":\"1.6\",\"description\":\"TZ_PORTFOLIO_PLUS_TPL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"template\"}', '{\"use_single_layout_builder\":\"0\",\"load_style\":\"1\",\"ratio\":\"5:3\",\"bgcolor\":\"rgba(0, 0, 0, 0.5)\",\"textcolor\":\"rgba(255, 255, 255, 1)\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '0'),
('21', 'plg_content_gallery', 'tz_portfolio_plus-plugin', 'gallery', 'content', '0', '{\"name\":\"plg_content_gallery\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"February 26th, 2021\",\"author\":\"Sonny\",\"copyright\":\"Copyright (C) 2015-2021 TZ Portfolio. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"1.0.1\",\"description\":\"PLG_CONTENT_GALLERY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"gallery\"}', '{\"gallery_file_size\":\"10\",\"gallery_file_type\":\"bmp,gif,jpg,jpeg,png\",\"gallery_lightbox_option\":\"[\\\"zoom\\\", \\\"slideShow\\\", \\\"fullScreen\\\", \\\"thumbs\\\", \\\"close\\\"]\",\"gallery_size\":\"{\\\"title\\\":\\\"XSmall\\\",\\\"width\\\":\\\"100\\\",\\\"image_name_prefix\\\":\\\"xs\\\"},{\\\"title\\\":\\\"Small\\\",\\\"width\\\":\\\"200\\\",\\\"image_name_prefix\\\":\\\"s\\\"},{\\\"title\\\":\\\"Medium\\\",\\\"width\\\":\\\"400\\\",\\\"image_name_prefix\\\":\\\"m\\\"},{\\\"title\\\":\\\"Large\\\",\\\"width\\\":\\\"600\\\",\\\"image_name_prefix\\\":\\\"l\\\"},{\\\"title\\\":\\\"XLarge\\\",\\\"width\\\":\\\"900\\\",\\\"image_name_prefix\\\":\\\"xl\\\"}\",\"mt_gallery_show\":\"1\",\"mt_gallery_type\":\"masonry\",\"mt_gallery_width\":\"400\",\"mt_gallery_height\":\"250\",\"mt_grid_image_title_position\":\"under_image\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '189'),
('22', 'plg_content_video', 'tz_portfolio_plus-plugin', 'video', 'content', '0', '{\"name\":\"plg_content_video\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"February 26th, 2021\",\"author\":\"Sonny\",\"copyright\":\"Copyright (C) 2015-2021 TZ Portfolio. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"1.0.1\",\"description\":\"PLG_CONTENT_VIDEO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"video\"}', '{}', '0', '0000-00-00 00:00:00', '1', '1', '0', '190'),
('23', 'plg_content_feature', 'tz_portfolio_plus-plugin', 'feature', 'content', '0', '{\"name\":\"plg_content_feature\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"May, 6th 2021\",\"author\":\"Sonny\",\"copyright\":\"Copyright (C) 2011-2021 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.tzportfolio.com\",\"version\":\"1.0.1\",\"description\":\"PLG_CONTENT_FEATURE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"feature\"}', '{\"cat_feature_content_show\":\"0\",\"feature_content_show\":\"1\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '191');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_content_rejected` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__tz_portfolio_plus_content table.',
  `created` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL COMMENT 'FK to the #__users table.',
  `message` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_content_rating` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `lastip` varchar(50) NOT NULL DEFAULT '',
  `rating_sum` int(11) NOT NULL DEFAULT 0,
  `rating_count` int(11) NOT NULL DEFAULT 0,
  KEY `extravote_idx` (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_content_featured_map` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_content_category_map` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contentid` int(11) NOT NULL DEFAULT 0,
  `catid` int(11) NOT NULL DEFAULT 0,
  `main` tinyint(4) NOT NULL COMMENT 'Main Category',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_content_category_map`  VALUES 
('1', '2', '3', '1'),
('2', '3', '3', '1'),
('3', '4', '3', '1'),
('4', '5', '3', '1'),
('5', '6', '3', '1'),
('6', '7', '3', '1'),
('7', '8', '3', '1'),
('8', '9', '3', '1'),
('9', '10', '3', '1'),
('10', '11', '2', '1');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `groupid` int(11) NOT NULL DEFAULT 0,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `introtext` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fulltext` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Store old state to restore state',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `urls` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribs` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `metakey` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadesc` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `metadata` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The language code for the article.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `media` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template_id` int(11) NOT NULL DEFAULT 0,
  `priority` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_content`  VALUES 
('1', '0', '174', 'First day in school', 'first-day-in-school', '<p>Roasting coffee transforms the chemical and physical properties of green coffee beans into roasted coffee products. The roasting process is what produces the characteristic flavor of coffee by causing the green coffee beans to change in taste.</p>\r\n', '\r\n<p>Unroasted beans contain similar if not higher levels of acids, protein, sugars, and caffeine as those that have been roasted, but lack the taste of roasted coffee beans due to the Maillard and other chemical reactions that occur during roasting.</p>\r\n<blockquote>\r\n<p>The majority of coffee is roasted on a large scale, but small-scale roasting has grown with the trend toward specialty shops.</p>\r\n</blockquote>\r\n<h3> Equipment</h3>\r\n<p>The most common roasting machines are of two basic types: drum and hot-air, although there are others including packed-bed, tangential and centrifugal roasters. Roasters can operate in either batch or continuous modes. Home roasters are also available.</p>\r\n<p><img src=\"images/tz_educab/anna-earl-6zA_-eCUtK0-unsplash.jpg\" alt=\"\" /></p>\r\n<p>Drum machines consist of horizontal rotating drums that tumble the green coffee beans in a heated environment. The heat source can be supplied by natural gas, liquefied petroleum gas (LPG), electricity, or even wood. The most common employ indirectly heated drums where the heat source is under the drum. Direct-fired roasters are roasters in which a flame contacts the beans inside the drum; very few of these machines are still in operation.</p>\r\n<blockquote>\r\n<p>The most common roasting machines are of two basic types: drum and hot-air, although there are others including packed-bed, tangential and centrifugal roasters.</p>\r\n</blockquote>\r\n<p>Hot-air roasters force heated air through a screen or perforated plate under the coffee beans with sufficient force to lift the beans. Heat is transferred to the beans as they tumble and circulate within this fluidized bed. Some coffee roasters use names for the various degrees of roast, such as City Roast and French Roast, for the internal bean temperatures found during roasting.</p>', '1', '0', '2020-12-07 03:11:32', '777', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:32', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '1', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{}', '0', '0'),
('2', '0', '175', 'Strategic Consulting', 'strategic-consulting', '<p>Optimizing the international supply chain; evaluating DC efficiencies; analytics for controlling your spend; the labor market and its impact on DC site selection; choosing between conveyor-based or cart-based picking.</p>\r\n', '\r\n<p>While an appropriate effort for most graduates is to start working as soon as possible after graduation, they may not have managed to land a job yet, despite several applications and CV sprucing done. If you’ve been finding it hard to secure a job before you’ve graduated, don’t despair! Instead of the searching path before any determined goal, here are some tips to keep you busy and productive while helping you discover yourself.</p>\r\n<h3>Building an environment conducive to doing business.</h3>\r\n<p>If you’re a little financially stable, consider volunteering at an NGO or some kind of charity that you’re enthusiastic about whilst waiting to secure a full-time job after graduation.</p>\r\n<ul>\r\n<li>Feature 7 hours of dedicated, non-compete Exhibit Hall hours</li>\r\n<li>Some of the best relationships are built in a relaxed social setting</li>\r\n<li>Your exhibitor package includes two conference passes per 10’ x 10’ booth</li>\r\n</ul>\r\n<p>Through volunteering, you may find other like-minded people in a similar profession who will recognize your passion. They may surprise you by offering a job to you or at least point you in the right direction.</p>\r\n<h3>A better understanding of the business problems</h3>\r\n<p>Now freelancing is a popular term among millennials, and now Gen Z-ers are also jumping into the pool. It is the right time to try your hand at freelancing if you’re looking for money while studying.</p>\r\n<p>If you’re unable to find a full-time job, freelancing is a great way to gain early industry experience, learn about the working environment, and make worthy contacts in your industry.</p>\r\n<blockquote>\r\n<p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.</p>\r\n<small>Samantha Akkineni</small></blockquote>\r\n<p>Robyn D Shulman, a creator on Forbes advises that graduates must post their own freelance jobs in online job boards such as Fivver, Upwork, and Linkedin Profinder – websites where freelancers can bid on projects.</p>\r\n<p> </p>\r\n<p> </p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2021-03-17 01:51:36', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_gallery_show\":\"\",\"mt_gallery_size\":\"\",\"mt_gallery_type\":\"\",\"mt_gallery_width\":\"\",\"mt_gallery_height\":\"\",\"mt_grid_image_title_position\":\"\",\"mt_video_show\":\"\",\"cat_feature_content_show\":\"\",\"feature_content_show\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '10', '8', '', '', '1', '7', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/strategic-consulting-2.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/strategic-consulting-2-h.jpg\"}}', '0', '0'),
('3', '0', '176', 'Driver License Control', 'driver-license-control', '<p>EXPO is the intermodal industry’s platform for products, services, and solutions; a classroom for new skills and know-how; and an exchange for ideas and business.</p>\r\n', '\r\n<h3>Living and breathing the world of Supply Chain Management</h3>\r\n<p>All necessary precautions will be taken by IANA to ensure a safe and secure event for all attendees and exhibitors. A virtual component will be offered to allow for greater participation by those who may be unable to attend</p>\r\n<blockquote>\r\n<p>Members of the intermodal freight community attend presentations on the technologies impacting intermodal and ways to strengthen shipper/drayage partnerships.</p>\r\n<small>Samantha Akkineni</small></blockquote>\r\n<p>Despite their best efforts many schools have struggled to adapt to the current crisis, with teachers under a lot of strain to keep lessons going without systems designed to help them manage their curriculums appropriately. As time has progressed, many people (particularly parents) have asked why technology.</p>\r\n<ul>\r\n<li>Intermodal industry’s platform for products, services and solutions</li>\r\n<li>A classroom for new skills and know-how</li>\r\n<li>An exchange for ideas and business</li>\r\n</ul>\r\n<h3>Digital transformation to sustainability</h3>\r\n<p>This webinar will present Open eLMS Live - a system designed to help teachers deliver a timetable of classroom learning remotely using existing teleconferencing systems and online learning resources. We are confident that you will see the benefits of running this remote learning platform now and also when your school reopens. It will also enable you to create a plan of action should a shutdown be necessary at any time in the future.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2021-03-17 01:39:22', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_gallery_show\":\"\",\"mt_gallery_size\":\"\",\"mt_gallery_type\":\"\",\"mt_gallery_width\":\"\",\"mt_gallery_height\":\"\",\"mt_grid_image_title_position\":\"\",\"mt_video_show\":\"\",\"cat_feature_content_show\":\"\",\"feature_content_show\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '5', '7', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/driver-license-control-3.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/driver-license-control-3-h.jpg\"}}', '0', '0'),
('4', '0', '177', 'Online Reporting Suite', 'online-reporting-suite', '<p>More than 100 sessions explore strategies that industry leaders have implemented to maximize and transform their company\'s supply chain.</p>\r\n', '\r\n<h3>Strategies for a customer-centric supply chain</h3>\r\n<p>The Lion’s Heart Scholarship program is a full scholarship that covers the tuition fees for Pathway programs, an undergraduate course at the British University Vietnam, English Preparation course, traveling cost for attending the scholarship interview round for students who are not in Hanoi and Hung Yen (if needed) and living costs for the scholar.</p>\r\n<blockquote>\r\n<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<small>- JEAN-LUC PICARD</small></blockquote>\r\n<p>A key feature of the program is to contribute to the Education of Vietnam’s development through providing the world-class higher education opportunities offered at the first British-owned university in Vietnam to disadvantaged students. </p>\r\n<ul>\r\n<li>Advocacy and Policy Development</li>\r\n<li>Professional Networking</li>\r\n<li>Education and Information</li>\r\n</ul>\r\n<h3>Innovative supply chain solutions</h3>\r\n<p>The event delves into key strategies to create more sustainable, strategic, and value-driven supply chains. Aside from organizational insights, participants come away with career takeaways and network with professionals shaping the future of supply chain, logistics, and operations management.</p>\r\n<blockquote>\r\n<p>Exploring best practices to drive supply chain innovation, the APICS conference highlights key value chain initiatives</p>\r\n<small>- JEAN-LUC PICARD</small></blockquote>\r\n<p>Candidates will be evaluated and selected for the round based on their financial situation, academic results, community volunteer participation, major choice, leadership potential, and ability to contribute to the development of BUV. Additionally, students need to supplement a certificate or a record confirming candidates’ circumstances or health status issued by the authorities.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2021-03-17 01:54:00', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_gallery_show\":\"\",\"mt_gallery_size\":\"\",\"mt_gallery_type\":\"\",\"mt_gallery_width\":\"\",\"mt_gallery_height\":\"\",\"mt_grid_image_title_position\":\"\",\"mt_video_show\":\"\",\"cat_feature_content_show\":\"\",\"feature_content_show\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '5', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/online-reporting-suite-4.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/online-reporting-suite-4-h.jpg\"}}', '0', '0'),
('5', '0', '178', 'Invoice control & processing', 'invoice-control-processing', '<p>CSCMP’s EDGE supply chain conference and exhibition is an event like no other, with unlimited opportunities to learn from industry experts, hear dynamic speakers you won’t find anywhere else and network with the most influential supply chain leaders in the world.</p>\r\n', '\r\n<h3>The hub of state’s entertainment and hospitality district</h3>\r\n<p>Welcome to Atlanta, Georgia! The Georgia World Congress Center Authority campus is the hub of the state’s entertainment and hospitality district. Beginning with a single exhibition hall, the GWCCA campus now includes 22-acre Centennial Olympic Park, Mercedes-Benz Stadium, International Plaza, multiple parking decks, the College Football Hall of Fame, Junior Achievement Discovery Center and the 3.9-million-square-foot convention center.</p>\r\n<h3>What’s most important in supply chain</h3>\r\n<blockquote>\r\n<p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.</p>\r\n<small>Samantha Akkineni</small></blockquote>\r\n<p>Masks create a barrier between a speaker’s voice and the listener’s ear. This will not only reduce the volume of speech but can also reduce the clarity, making it more difficult for all students not just those who are hard of hearing to understand the teacher and their peers. Masks also make speechreading impossible, which is an essential communication strategy for many people with hearing loss.</p>\r\n<h3>Discover ATLANTA</h3>\r\n<ul>\r\n<li>22 dedicated tracks and over 120 sessions spanning the end-to-end supply chain</li>\r\n<li>At vero eos et <a href=\"https://www.templaza.com/\">accusamus et iusto</a> odio.</li>\r\n<li>Excepteur <em>sint occaecat</em> cupidatat non proident.</li>\r\n</ul>\r\n<p>Social distancing is another factor to consider. It can help control viral spread, but it also reduces the volume of speech. In fact, every time the distance between a speaker and listener is doubled, the sound intensity drops by about 25 percent. Typically, teachers use an FM system a microphone worn that transmits a direct sound signal to a receiver worn by a child to help deliver sounds right to their hearing aid or cochlear implant. But speaking into a microphone with a face covering could result in friction between the two surfaces, which could create sound interference.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2021-03-17 01:35:52', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_gallery_show\":\"\",\"mt_gallery_size\":\"\",\"mt_gallery_type\":\"\",\"mt_gallery_width\":\"\",\"mt_gallery_height\":\"\",\"mt_grid_image_title_position\":\"\",\"mt_video_show\":\"\",\"cat_feature_content_show\":\"\",\"feature_content_show\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '4', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/invoice-control-processing-5.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/invoice-control-processing-5-h.jpg\"}}', '0', '0'),
('6', '0', '180', 'Fuel Management', 'fuel-management', '<p>In just a few short weeks, the normal educational schedule was thrown into chaos. Schools, colleges and universities were faced with complete shut down - no pupils, no teachers and a significantly reduced ability to deliver lessons in a meaningful way.</p>\r\n', '\r\n<h3>LOREM IPSUM DOLOR SIT AMET</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam hendrerit nisi sed sollicitudin pellentesque. Nunc posuere purus rhoncus pulvinar aliquam. Ut aliquet tristique nisl vitae volutpat. Nulla aliquet porttitor venenatis. Donec a dui et dui fringilla consectetur id nec massa.</p>\r\n<blockquote>\r\n<p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.</p>\r\n<small>Samantha Akkineni</small></blockquote>\r\n<p>Despite their best efforts many schools have struggled to adapt to the current crisis, with teachers under a lot of strain to keep lessons going without systems designed to help them manage their curriculums appropriately. As time has progressed, many people (particularly parents) have asked why technology, that is increasingly used in our private lives (particularly younger generations), is not being utilised to its full potential in education. Experts in the industry are already predicting the impact of coronavirus will compel many institutions to rethink their learning strategies.</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet.</li>\r\n<li>At vero eos et <a href=\"https://www.templaza.com/\">accusamus et iusto</a> odio.</li>\r\n<li>Excepteur <em>sint occaecat</em> cupidatat non proident.</li>\r\n</ul>\r\n<h3>DUIS AUTE IRURE DOLOR IN REPREHENDERIT</h3>\r\n<p>This webinar will present Open eLMS Live - a system designed to help teachers deliver a timetable of classroom learning remotely using existing teleconferencing systems and online learning resources. We are confident that you will see the benefits of running this remote learning platform now and also when your school reopens. It will also enable you to create a plan of action should a shutdown be necessary at any time in the future.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2021-03-17 01:41:44', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_gallery_show\":\"\",\"mt_gallery_size\":\"\",\"mt_gallery_type\":\"\",\"mt_gallery_width\":\"\",\"mt_gallery_height\":\"\",\"mt_grid_image_title_position\":\"\",\"mt_video_show\":\"\",\"cat_feature_content_show\":\"\",\"feature_content_show\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '3', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/fuel-management-6.jpeg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/fuel-management-6-h.jpeg\"}}', '0', '0'),
('7', '0', '181', 'Vehicle Ordering', 'vehicle-ordering', '<p>CMA Shipping\'s virtual platform hosts live and on-demand sessions throughout the event. </p>\r\n', '\r\n<h3>Call for Papers</h3>\r\n<p>Expert speakers provide insights into hot topics in the global maritime industry, including the impact of COVID-19, an update from the U.S. Coast Guard on IMO 2020 compliance and enforcement, and what effect automation in the workforce will have on the shipping industry.</p>\r\n<blockquote>\r\n<p>With SHIPPINGInsight’s focus on technology and innovation and CMA Shipping’s emphasis on the commercial aspects of shipping, this is a winning combination to give value to all attendees. </p>\r\n<small>Jessica Alba</small></blockquote>\r\n<p>Because Autism Spectrum Disorder affects communication and behavior, an ASD diagnosis can pose unique challenges to social learning. Limited interests and repetitive behaviors often impair a person’s ability to function in a school environment.</p>\r\n<p>Wouldn’t it be great if there were protocols for embedding recognizable patterns and comforting routines into content delivery while providing stimulating opportunities for student-led discovery? What if I told you that Arts Integrated Teaching can not only enliven your classroom but also be a lifeline for those with ASD? Even teachers without prior experience in the arts can effectively use visual art and music to achieve learning targets with students regardless of ability.</p>\r\n<h3>Your Leading Industry Event Returns</h3>\r\n<p>As an elementary Music Teacher, I enjoy being instrumental in helping children express themselves. When my school was awarded grant funding for Arts Integration, my fine arts colleagues and I were ecstatic! Colorful hallways lined with student paintings and music pouring out of every door seemed an ideal environment for engaged learning. However, some of our general education colleagues were less enthused. </p>\r\n<ul>\r\n<li>The Commodore Award</li>\r\n<li>Sponsorship &amp; Exhibition Opportunities</li>\r\n<li>CMA Membership</li>\r\n</ul>\r\n<p>Let’s delve into specific ways in which drawing, responding to imagery, and engaging in music can positively impact the communication, emotional, and sensory needs of students on the autism spectrum in your class.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2021-03-16 09:45:18', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_gallery_show\":\"\",\"mt_gallery_size\":\"\",\"mt_gallery_type\":\"\",\"mt_gallery_width\":\"\",\"mt_gallery_height\":\"\",\"mt_grid_image_title_position\":\"\",\"mt_video_show\":\"\",\"cat_feature_content_show\":\"\",\"feature_content_show\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '3', '3', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/vehicle-ordering-7.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/vehicle-ordering-7-h.jpg\"}}', '0', '0'),
('8', '0', '182', 'Vendor management', 'vendor-management', '<p>CMA Shipping\'s virtual platform hosts live and on-demand sessions throughout the event. </p>\r\n', '\r\n<h3>Call for Papers</h3>\r\n<p>Expert speakers provide insights into hot topics in the global maritime industry, including the impact of COVID-19, an update from the U.S. Coast Guard on IMO 2020 compliance and enforcement, and what effect automation in the workforce will have on the shipping industry.</p>\r\n<blockquote>\r\n<p>With SHIPPINGInsight’s focus on technology and innovation and CMA Shipping’s emphasis on the commercial aspects of shipping, this is a winning combination to give value to all attendees. </p>\r\n<small>Jessica Alba</small></blockquote>\r\n<p>Because Autism Spectrum Disorder affects communication and behaviour, an ASD diagnosis can pose unique challenges to social learning. Limited interests and repetitive behaviours often impair a person’s ability to function in a school environment.</p>\r\n<h3>Your Leading Industry Event Returns</h3>\r\n<p>As an elementary Music Teacher, I enjoy being instrumental in helping children express themselves. When my school was awarded grant funding for Arts Integration, my fine arts colleagues and I were ecstatic! Colourful hallways lined with student paintings and music pouring out of every door seemed an ideal environment for engaged learning. However, some of our general education colleagues were less enthused. </p>\r\n<ul>\r\n<li>The Commodore Award</li>\r\n<li>Sponsorship &amp; Exhibition Opportunities</li>\r\n<li>CMA Membership</li>\r\n</ul>\r\n<p>Let’s delve into specific ways in which drawing, responding to imagery, and engaging in music can positively impact the communication, emotional, and sensory needs of students on the autism spectrum in your class.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2021-03-17 01:53:11', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_gallery_show\":\"\",\"mt_gallery_size\":\"\",\"mt_gallery_type\":\"\",\"mt_gallery_width\":\"\",\"mt_gallery_height\":\"\",\"mt_grid_image_title_position\":\"\",\"mt_video_show\":\"\",\"cat_feature_content_show\":\"\",\"feature_content_show\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '5', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/vendor-management-8.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/vendor-management-8-h.jpg\"}}', '0', '0'),
('9', '0', '183', 'Outsourcing', 'outsourcing', '<p>With the commitment to contribute to the development of Education of Vietnam by giving students the opportunity to study UK undergraduate and postgraduate programs in an international learning environment in Vietnam.</p>\r\n', '\r\n<h3>LOREM IPSUM DOLOR SIT AMET</h3>\r\n<p>The Lion’s Heart Scholarship programme is a full scholarship that covers the tuition fees for Pathway programmes, an undergraduate course at the British University Vietnam, English Preparation course, traveling cost for attending the scholarship interview round for students who are not in Hanoi and Hung Yen (if needed) and living costs for the scholar.</p>\r\n<blockquote>\r\n<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<small>- JEAN-LUC PICARD</small></blockquote>\r\n<p>A key feature of the programme is to contribute to the Education of Vietnam’s development through providing the world-class higher education opportunities offered at the first British owned university in Vietnam to disadvantaged students. The candidates are selected based on their disadvantaged background including their need for financial support, physical or mental disability along with a combination of previous academic performance, relevant experience of community work and the potential to become leaders in the public sector, business, and academia. For the school year 2020 – 2021, BUV will grant 1 Lion’s Heart Scholarship a value of up to over VND 1 billion.</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet.</li>\r\n<li>At vero eos et <a href=\"https://www.templaza.com/\">accusamus et iusto</a> odio.</li>\r\n<li>Excepteur <em>sint occaecat</em> cupidatat non proident.</li>\r\n</ul>\r\n<h3>UT ENIM AD MINIM VENIAM</h3>\r\n<p>The scholarship programme applies to the following courses, which are entirely taught at BUV and awarded by Staffordshire University: BSc (Hons) International Business Management, BSc (Hons) Computer Science: Cyber Security/Cloud, Networks and Security, BA (Hons) Marketing Management, BA (Hons) Accounting and Finance, BA (Hons) Finance and Economics, BA (Hons) Tourism Management, BA (Hons) Events Management, BA (Hons) Contemporary Creative Practice: Graphic Design/ Illustration/ Photography, BA (Hons) Computer Games Design and Programming, BA (Hons) International Hospitality Management.</p>\r\n<blockquote>\r\n<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<small>- JEAN-LUC PICARD</small></blockquote>\r\n<p>Candidates will be evaluated and selected for the round based on their financial situation, academic results, community volunteer participation, major choice, leadership potential, and ability to contribute to the development of BUV. Additionally, students need to supplement a certificate or a record confirming candidates’ circumstances or health status issued by the authorities.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2021-03-16 09:36:19', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_gallery_show\":\"\",\"mt_gallery_size\":\"\",\"mt_gallery_type\":\"\",\"mt_gallery_width\":\"\",\"mt_gallery_height\":\"\",\"mt_grid_image_title_position\":\"\",\"mt_video_show\":\"\",\"cat_feature_content_show\":\"\",\"feature_content_show\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '4', '1', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/outsourcing-9.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/outsourcing-9-h.jpg\"}}', '0', '0'),
('10', '0', '184', 'Vehicle sourcing', 'vehicle-sourcing', '<p>With the commitment to contribute to the development of Education of Vietnam by giving students the opportunity to study UK undergraduate and postgraduate programs in an international learning environment in Vietnam, in the school year of 2020 – 2021, British University Vietnam has officially launched Lion’s Heart Scholarship specifically for disadvantaged students who always make great effort to overcome the difficulties in life.</p>\r\n', '\r\n<h3>LOREM IPSUM DOLOR SIT AMET</h3>\r\n<p>The Lion’s Heart Scholarship programme is a full scholarship that covers the tuition fees for Pathway programmes, an undergraduate course at the British University Vietnam, English Preparation course, traveling cost for attending the scholarship interview round for students who are not in Hanoi and Hung Yen (if needed) and living costs for the scholar.</p>\r\n<blockquote>\r\n<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<small>- JEAN-LUC PICARD</small></blockquote>\r\n<p>A key feature of the programme is to contribute to the Education of Vietnam’s development through providing the world-class higher education opportunities offered at the first British owned university in Vietnam to disadvantaged students. The candidates are selected based on their disadvantaged background including their need for financial support, physical or mental disability along with a combination of previous academic performance, relevant experience of community work and the potential to become leaders in the public sector, business, and academia. For the school year 2020 – 2021, BUV will grant 1 Lion’s Heart Scholarship a value of up to over VND 1 billion.</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet.</li>\r\n<li>At vero eos et <a href=\"https://www.templaza.com/\">accusamus et iusto</a> odio.</li>\r\n<li>Excepteur <em>sint occaecat</em> cupidatat non proident.</li>\r\n</ul>\r\n<h3>UT ENIM AD MINIM VENIAM</h3>\r\n<p>The scholarship programme applies to the following courses, which are entirely taught at BUV and awarded by Staffordshire University: BSc (Hons) International Business Management, BSc (Hons) Computer Science: Cyber Security/Cloud, Networks and Security, BA (Hons) Marketing Management, BA (Hons) Accounting and Finance, BA (Hons) Finance and Economics, BA (Hons) Tourism Management, BA (Hons) Events Management, BA (Hons) Contemporary Creative Practice: Graphic Design/ Illustration/ Photography, BA (Hons) Computer Games Design and Programming, BA (Hons) International Hospitality Management.</p>\r\n<blockquote>\r\n<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<small>- JEAN-LUC PICARD</small></blockquote>\r\n<p>Candidates will be evaluated and selected for the round based on their financial situation, academic results, community volunteer participation, major choice, leadership potential, and ability to contribute to the development of BUV. Additionally, students need to supplement a certificate or a record confirming candidates’ circumstances or health status issued by the authorities.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2021-03-16 09:34:25', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_gallery_show\":\"\",\"mt_gallery_size\":\"\",\"mt_gallery_type\":\"\",\"mt_gallery_width\":\"\",\"mt_gallery_height\":\"\",\"mt_grid_image_title_position\":\"\",\"mt_video_show\":\"\",\"cat_feature_content_show\":\"\",\"feature_content_show\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '5', '0', '', '', '1', '4', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/vehicle-sourcing-10.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/vehicle-sourcing-10-h.jpg\"}}', '0', '0'),
('11', '0', '192', 'Test', 'test', '', '', '-2', '1', '2021-02-22 08:56:29', '777', '', '2021-02-24 10:15:28', '777', '0', '0000-00-00 00:00:00', '2021-02-22 08:56:29', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_gallery_show\":\"\",\"mt_gallery_size\":\"\",\"mt_gallery_type\":\"\",\"mt_gallery_width\":\"\",\"mt_gallery_height\":\"\",\"mt_grid_image_title_position\":\"\",\"mt_video_show\":\"\",\"cat_feature_content_show\":\"\",\"feature_content_show\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '2', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/test-11.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/test-11-h.jpg\"}}', '0', '0');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupid` int(11) NOT NULL DEFAULT 0,
  `images` text DEFAULT NULL,
  `template_id` int(10) unsigned NOT NULL DEFAULT 0,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(11) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` text DEFAULT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_categories`  VALUES 
('1', '0', '', '0', '0', '0', '0', '5', '0', '', 'system', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{}', '', '', '', '777', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1'),
('2', '0', '', '0', '158', '1', '1', '2', '1', 'uncategorised', 'com_tz_portfolio_plus', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"inheritFrom\":\"0\",\"category_layout\":\"\",\"image\":\"\",\"show_cat_title\":\"1\",\"cat_link_titles\":\"1\",\"show_cat_intro\":\"1\",\"show_cat_category\":\"0\",\"cat_link_category\":\"1\",\"show_cat_parent_category\":\"0\",\"cat_link_parent_category\":\"1\",\"show_cat_author\":\"0\",\"cat_link_author\":\"1\",\"show_cat_create_date\":\"0\",\"show_cat_modify_date\":\"0\",\"show_cat_publish_date\":\"0\",\"show_cat_readmore\":\"1\",\"show_cat_hits\":\"0\",\"show_cat_tags\":\"0\",\"show_cat_icons\":\"1\",\"show_cat_print_icon\":\"0\",\"show_cat_email_icon\":\"0\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_noauth\":\"0\",\"link_category\":\"1\",\"link_parent_category\":\"1\",\"show_gender_user\":\"1\",\"show_email_user\":\"1\",\"show_url_user\":\"1\",\"show_description_user\":\"1\",\"show_related_article\":\"1\",\"related_limit\":\"5\",\"show_related_heading\":\"1\",\"related_heading\":\"\",\"show_related_title\":\"1\",\"show_related_featured\":\"1\",\"related_orderby\":\"rdate\",\"mt_show_cat_image_hover\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_size\":\"\",\"mt_show_image_hover\":\"\",\"mt_image_use_cloud\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\",\"show_cat_vote\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '777', '2015-12-12 14:42:28', '0', '2015-12-12 14:42:28', '0', '*', '1'),
('3', '0', '', '0', '173', '1', '3', '4', '1', 'gallery', 'com_tz_portfolio_plus', 'Gallery', 'gallery', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"inheritFrom\":\"0\",\"show_cat_title\":\"0\",\"cat_link_titles\":\"1\",\"show_cat_intro\":\"0\",\"show_cat_category\":\"0\",\"cat_link_category\":\"1\",\"show_cat_parent_category\":\"0\",\"cat_link_parent_category\":\"1\",\"show_cat_author\":\"0\",\"cat_link_author\":\"1\",\"show_cat_create_date\":\"0\",\"show_cat_modify_date\":\"0\",\"show_cat_publish_date\":\"0\",\"show_cat_readmore\":\"0\",\"show_cat_hits\":\"0\",\"show_cat_tags\":\"0\",\"show_cat_icons\":\"1\",\"show_cat_print_icon\":\"0\",\"show_cat_email_icon\":\"0\",\"show_title\":\"1\",\"show_intro\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"1\",\"link_parent_category\":\"1\",\"show_author\":\"1\",\"link_author\":\"1\",\"show_create_date\":\"1\",\"show_modify_date\":\"1\",\"show_publish_date\":\"1\",\"show_hits\":\"1\",\"show_tags\":\"1\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_noauth\":\"0\",\"show_about_author\":\"1\",\"show_gender_user\":\"1\",\"show_email_user\":\"1\",\"show_url_user\":\"1\",\"show_description_user\":\"1\",\"show_related_article\":\"1\",\"related_article_by\":\"tag\",\"related_limit\":\"5\",\"show_related_heading\":\"1\",\"related_heading\":\"\",\"show_related_title\":\"1\",\"show_related_featured\":\"1\",\"related_orderby\":\"rdate\",\"show_cat_vote\":\"\",\"show_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\",\"mt_image_watermark_admin_options\":{\"mt_image_watermark\":\"\",\"mt_image_wtm_original_image\":\"\",\"mt_image_watermark_img_detail\":\"\",\"mt_image_watermark_stype\":\"\"}}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '777', '2020-12-07 03:01:24', '777', '2020-12-07 03:19:43', '0', '*', '1');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_addon_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `addon_id` int(10) unsigned NOT NULL DEFAULT 0,
  `data_id` int(11) NOT NULL DEFAULT 0,
  `meta_id` int(11) NOT NULL DEFAULT 0,
  `meta_key` varchar(255) NOT NULL DEFAULT '',
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_addon_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `extension_id` int(11) NOT NULL,
  `element` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_addon_data`  VALUES 
('1', '21', 'gallery', '{\"title\":\"Test\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"custom_class\":\"\",\"gallery_content\":{\"gallery_image_title\":[\"\\u0111asadas\",\"\",\"\",\"\"],\"gallery_image\":[\"sindy-strife-6vktlnb-dxs-unsplash.jpg\",\"patti-black-2lo0cktmfcg-unsplash.jpg\",\"joshua-j-cotten-u1zjvgj1nhm-unsplash.jpg\",\"ela108-garwacka-goralik-mx9rbf-baf8-unsplash.jpg\"],\"image_featured\":\"ela108-garwacka-goralik-mx9rbf-baf8-unsplash.jpg\"}}', '11', '1', '0', '0', '2021-02-22 08:56:29', '777', '2021-02-24 10:15:28', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('2', '22', 'video', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"video_url\":\"\",\"autoplay\":\"0\",\"loop\":\"0\",\"muted\":\"0\",\"autopause\":\"1\",\"byline\":\"1\",\"video_title\":\"1\",\"portrait\":\"1\",\"controls\":\"1\",\"show_rel_video\":\"0\",\"no_cookie\":\"0\",\"custom_class\":\"\"}', '11', '1', '0', '0', '2021-02-22 08:56:29', '777', '2021-02-24 10:15:28', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('3', '23', 'feature', '{\"feature_width_md\":\"col-md-12\",\"feature_width_sm\":\"col-sm-12\",\"feature_width_xs\":\"col-xs-12\",\"tzportfolio_addon_features\":\"\"}', '11', '1', '0', '0', '2021-02-22 08:56:29', '777', '2021-02-24 10:15:28', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('4', '21', 'gallery', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"custom_class\":\"\",\"gallery_content\":[]}', '10', '1', '0', '0', '2021-03-16 09:34:25', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('5', '22', 'video', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"video_url\":\"\",\"autoplay\":\"0\",\"loop\":\"0\",\"muted\":\"0\",\"autopause\":\"1\",\"byline\":\"1\",\"video_title\":\"1\",\"portrait\":\"1\",\"controls\":\"1\",\"show_rel_video\":\"0\",\"no_cookie\":\"0\",\"custom_class\":\"\"}', '10', '1', '0', '0', '2021-03-16 09:34:25', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('6', '23', 'feature', '{\"feature_width_md\":\"col-md-12\",\"feature_width_sm\":\"col-sm-12\",\"feature_width_xs\":\"col-xs-12\",\"tzportfolio_addon_features\":\"\"}', '10', '1', '0', '0', '2021-03-16 09:34:25', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('7', '21', 'gallery', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"custom_class\":\"\",\"gallery_content\":[]}', '9', '1', '0', '0', '2021-03-16 09:36:19', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('8', '22', 'video', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"video_url\":\"\",\"autoplay\":\"0\",\"loop\":\"0\",\"muted\":\"0\",\"autopause\":\"1\",\"byline\":\"1\",\"video_title\":\"1\",\"portrait\":\"1\",\"controls\":\"1\",\"show_rel_video\":\"0\",\"no_cookie\":\"0\",\"custom_class\":\"\"}', '9', '1', '0', '0', '2021-03-16 09:36:19', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('9', '23', 'feature', '{\"feature_width_md\":\"col-md-12\",\"feature_width_sm\":\"col-sm-12\",\"feature_width_xs\":\"col-xs-12\",\"tzportfolio_addon_features\":\"\"}', '9', '1', '0', '0', '2021-03-16 09:36:19', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('10', '21', 'gallery', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"custom_class\":\"\",\"gallery_content\":[]}', '8', '1', '0', '0', '2021-03-16 09:40:10', '777', '2021-03-17 01:53:11', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('11', '22', 'video', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"video_url\":\"\",\"autoplay\":\"0\",\"loop\":\"0\",\"muted\":\"0\",\"autopause\":\"1\",\"byline\":\"1\",\"video_title\":\"1\",\"portrait\":\"1\",\"controls\":\"1\",\"show_rel_video\":\"0\",\"no_cookie\":\"0\",\"custom_class\":\"\"}', '8', '1', '0', '0', '2021-03-16 09:40:10', '777', '2021-03-17 01:53:11', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('12', '23', 'feature', '{\"feature_width_md\":\"col-md-12\",\"feature_width_sm\":\"col-sm-12\",\"feature_width_xs\":\"col-xs-12\",\"tzportfolio_addon_features\":\"\"}', '8', '1', '0', '0', '2021-03-16 09:40:10', '777', '2021-03-17 01:53:11', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('13', '21', 'gallery', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"custom_class\":\"\",\"gallery_content\":[]}', '7', '1', '0', '0', '2021-03-16 09:45:18', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('14', '22', 'video', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"video_url\":\"\",\"autoplay\":\"0\",\"loop\":\"0\",\"muted\":\"0\",\"autopause\":\"1\",\"byline\":\"1\",\"video_title\":\"1\",\"portrait\":\"1\",\"controls\":\"1\",\"show_rel_video\":\"0\",\"no_cookie\":\"0\",\"custom_class\":\"\"}', '7', '1', '0', '0', '2021-03-16 09:45:18', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('15', '23', 'feature', '{\"feature_width_md\":\"col-md-12\",\"feature_width_sm\":\"col-sm-12\",\"feature_width_xs\":\"col-xs-12\",\"tzportfolio_addon_features\":\"\"}', '7', '1', '0', '0', '2021-03-16 09:45:18', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('16', '21', 'gallery', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"custom_class\":\"\",\"gallery_content\":[]}', '2', '1', '0', '0', '2021-03-17 01:30:39', '777', '2021-03-17 01:51:36', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('17', '22', 'video', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"video_url\":\"\",\"autoplay\":\"0\",\"loop\":\"0\",\"muted\":\"0\",\"autopause\":\"1\",\"byline\":\"1\",\"video_title\":\"1\",\"portrait\":\"1\",\"controls\":\"1\",\"show_rel_video\":\"0\",\"no_cookie\":\"0\",\"custom_class\":\"\"}', '2', '1', '0', '0', '2021-03-17 01:30:39', '777', '2021-03-17 01:51:36', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('18', '23', 'feature', '{\"feature_width_md\":\"col-md-12\",\"feature_width_sm\":\"col-sm-12\",\"feature_width_xs\":\"col-xs-12\",\"tzportfolio_addon_features\":\"\"}', '2', '1', '0', '0', '2021-03-17 01:30:39', '777', '2021-03-17 01:51:36', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('19', '21', 'gallery', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"custom_class\":\"\",\"gallery_content\":[]}', '5', '1', '0', '0', '2021-03-17 01:35:52', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('20', '22', 'video', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"video_url\":\"\",\"autoplay\":\"0\",\"loop\":\"0\",\"muted\":\"0\",\"autopause\":\"1\",\"byline\":\"1\",\"video_title\":\"1\",\"portrait\":\"1\",\"controls\":\"1\",\"show_rel_video\":\"0\",\"no_cookie\":\"0\",\"custom_class\":\"\"}', '5', '1', '0', '0', '2021-03-17 01:35:52', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('21', '23', 'feature', '{\"feature_width_md\":\"col-md-12\",\"feature_width_sm\":\"col-sm-12\",\"feature_width_xs\":\"col-xs-12\",\"tzportfolio_addon_features\":\"\"}', '5', '1', '0', '0', '2021-03-17 01:35:52', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('22', '21', 'gallery', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"custom_class\":\"\",\"gallery_content\":[]}', '3', '1', '0', '0', '2021-03-17 01:39:22', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('23', '22', 'video', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"video_url\":\"\",\"autoplay\":\"0\",\"loop\":\"0\",\"muted\":\"0\",\"autopause\":\"1\",\"byline\":\"1\",\"video_title\":\"1\",\"portrait\":\"1\",\"controls\":\"1\",\"show_rel_video\":\"0\",\"no_cookie\":\"0\",\"custom_class\":\"\"}', '3', '1', '0', '0', '2021-03-17 01:39:22', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('24', '23', 'feature', '{\"feature_width_md\":\"col-md-12\",\"feature_width_sm\":\"col-sm-12\",\"feature_width_xs\":\"col-xs-12\",\"tzportfolio_addon_features\":\"\"}', '3', '1', '0', '0', '2021-03-17 01:39:22', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('25', '21', 'gallery', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"custom_class\":\"\",\"gallery_content\":[]}', '6', '1', '0', '0', '2021-03-17 01:41:44', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('26', '22', 'video', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"video_url\":\"\",\"autoplay\":\"0\",\"loop\":\"0\",\"muted\":\"0\",\"autopause\":\"1\",\"byline\":\"1\",\"video_title\":\"1\",\"portrait\":\"1\",\"controls\":\"1\",\"show_rel_video\":\"0\",\"no_cookie\":\"0\",\"custom_class\":\"\"}', '6', '1', '0', '0', '2021-03-17 01:41:44', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('27', '23', 'feature', '{\"feature_width_md\":\"col-md-12\",\"feature_width_sm\":\"col-sm-12\",\"feature_width_xs\":\"col-xs-12\",\"tzportfolio_addon_features\":\"\"}', '6', '1', '0', '0', '2021-03-17 01:41:44', '777', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('28', '21', 'gallery', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"custom_class\":\"\",\"gallery_content\":[]}', '4', '1', '0', '0', '2021-03-17 01:50:07', '777', '2021-03-17 01:54:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('29', '22', 'video', '{\"title\":\"\",\"title_element\":\"h3\",\"title_font\":\"{\\\"fontFamily\\\":\\\"\\\",\\\"lineHeight\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"letterSpacing\\\":\\\"\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"textTransform\\\":\\\"\\\",\\\"textDecoration\\\":\\\"\\\"}\",\"title_color\":\"\",\"title_color_hover\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"video_url\":\"\",\"autoplay\":\"0\",\"loop\":\"0\",\"muted\":\"0\",\"autopause\":\"1\",\"byline\":\"1\",\"video_title\":\"1\",\"portrait\":\"1\",\"controls\":\"1\",\"show_rel_video\":\"0\",\"no_cookie\":\"0\",\"custom_class\":\"\"}', '4', '1', '0', '0', '2021-03-17 01:50:07', '777', '2021-03-17 01:54:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1'),
('30', '23', 'feature', '{\"feature_width_md\":\"col-md-12\",\"feature_width_sm\":\"col-sm-12\",\"feature_width_xs\":\"col-xs-12\",\"tzportfolio_addon_features\":\"\"}', '4', '1', '0', '0', '2021-03-17 01:50:07', '777', '2021-03-17 01:54:00', '0', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1');
/**ABDB**/CREATE TABLE `#__template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `home` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `inheritable` tinyint(4) NOT NULL DEFAULT 0,
  `parent` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_styles`  VALUES 
('18', 'tz_logistics', '0', '1', 'tz_logistics - Default', '[]', '0', ''),
('19', 'tz_logistics', '0', '0', 'tz_logistics - Home Page', '{\"astroid\":\"19\"}', '0', ''),
('20', 'tz_logistics', '0', '0', 'tz_logistics - Default - No Sidebar', '{\"astroid\":\"20\"}', '0', ''),
('21', 'tz_logistics', '0', '0', 'tz_logistics - Default - Page Builder', '{\"astroid\":\"21\"}', '0', ''),
('23', 'atum', '1', '1', 'Atum - Default', '{\"hue\":\"hsl(214, 63%, 20%)\",\"bg-light\":\"#f0f4fb\",\"text-dark\":\"#495057\",\"text-light\":\"#ffffff\",\"link-color\":\"#2a69b8\",\"special-color\":\"#001b4c\",\"monochrome\":\"0\",\"loginLogo\":\"\",\"loginLogoAlt\":\"\",\"logoBrandLarge\":\"\",\"logoBrandLargeAlt\":\"\",\"logoBrandSmall\":\"\",\"logoBrandSmallAlt\":\"\"}', '0', ''),
('24', 'cassiopeia', '0', '0', 'Cassiopeia - Default', '{}', '0', '');
/**ABDB**/CREATE TABLE `#__template_overrides` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hash_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension_id` int(11) DEFAULT 0,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `created_date` datetime NOT NULL,
  `modified_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_extension_id` (`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tags`  VALUES 
('1', '0', '0', '1', '0', '', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '', '', '', '', '777', '2020-08-21 07:54:09', '', '777', '2020-08-21 07:54:09', '', '', '0', '*', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__sppagebuilder_sections` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `section` mediumtext NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__sppagebuilder_sections`  VALUES 
('1', 'Subscribe', '{\"id\":1606210046443,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"50px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\"},\"layout\":\"12\",\"columns\":[{\"id\":1606210046442,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"md\":\"80px 9vw 80px 9vw\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background\":\"#ffc600\"},\"addons\":[{\"id\":1606210046446,\"name\":\"optin_form\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Subscribe Our Newsletter To Get More Update\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"52\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"platform\":\"acymailing\",\"hide_name\":0,\"acymailing_listids\":[\"1\"],\"mailchimp_api\":\"\",\"mailchimp_listid\":\"\",\"mailchimp_action\":\"subscribed\",\"sendgrid_api\":\"\",\"sendinblue_api\":\"\",\"sendinblue_listid\":\"\",\"madmimi_user\":\"\",\"madmimi_api\":\"\",\"madmimi_listname\":\"\",\"recaptcha\":0,\"show_checkbox\":1,\"checkbox_title\":\"I agree with the <a href=\\\"#\\\">Terms of Use</a> and <a href=\\\"#\\\">Privacy Policy</a> and I declare that I have read the information that is required in accordance with <a href=\\\"http://eur-lex.europa.eu/legal-content/EN/TXT/?uri=uriserv:OJ.L_.2016.119.01.0001.01.ENG&amp;toc=OJ:L:2016:119:TOC\\\" target=\\\"_blank\\\">Article 13 of GDPR.</a>\",\"grid\":\"\",\"optin_type\":\"normal\",\"optin_timein\":2000,\"optin_timeout\":10000,\"optin_width\":\"600\",\"alignment\":\"sppb-text-center\",\"form_inline\":0,\"submit_btn_inside\":0,\"custom_input\":0,\"custom_input_bgcolor\":\"rgba(239, 240, 244, 0.94)\",\"custom_input_color\":\"#999\",\"custom_input_borderless\":1,\"custom_input_border_side\":\"\",\"custom_input_border_style\":\"\",\"custom_input_padding\":\"22px 15px 22px 15px\",\"media_type\":\"\",\"image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"\",\"icon_name\":\"\",\"icon_size\":82,\"media_position\":\"\",\"content\":\"\",\"button_text\":\"SUBSCRIBE\",\"use_custom_button\":1,\"fontsize\":16,\"button_fontstyle\":\"\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"flat\",\"button_status\":\"hover\",\"button_background_color\":\"#5598ff\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#fff\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_font_family\":\"Montserrat\",\"title_font_style\":{\"weight\":800},\"title_text_color\":\"#00256e\",\"global_text_color\":\"rgb(72, 93, 136)\",\"global_link_color\":\"#00256e\",\"global_link_hover_color\":\"#1d3f83\",\"button_padding\":{\"md\":\"15px 25px 15px 25px\",\"sm\":\"   \",\"xs\":\"   \"},\"button_shape\":\"square\"}}]}]}', '2020-12-04 09:19:23', '777'),
('2', 'Slideshow', '{\"id\":1605085412219,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":1,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1605085412218,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615623425786,\"name\":\"uislideshow\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title_addon\":\"\",\"title_heading_style\":\"h3\",\"title_heading_margin\":\"uk-margin\",\"title_heading_decoration\":\"\",\"title_heading_color\":\"\",\"title_heading_selector\":\"h3\",\"ui_slideshow_items\":[{\"image_panel\":0,\"media_blend_mode\":\"\",\"title\":\"Welcome to Transport JSC.<br/>Fast & Convenient\",\"content\":\"Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.\",\"title_link\":\"#\",\"text_item_color\":\"light\",\"media_item\":\"images/rqa-bg.jpg\",\"button_title\":\"Contact Us\"},{\"image_panel\":0,\"media_blend_mode\":\"\",\"title\":\"Transport your goods.<br/>Around the World\",\"content\":\"Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.\",\"title_link\":\"#\",\"text_item_color\":\"light\",\"media_item\":\"images/plant.jpg\",\"button_title\":\"Get In Touch\"},{\"image_panel\":0,\"media_blend_mode\":\"\",\"title\":\"With help from our fleet.<br/>Send it anywhere\",\"content\":\"Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.\",\"title_link\":\"#\",\"text_item_color\":\"light\",\"media_item\":\"images/ship.jpg\",\"button_title\":\"Find a Vendor\"}],\"height\":\"\",\"ratio\":\"\",\"min_height\":300,\"item_color\":\"light\",\"box_shadow\":\"\",\"slideshow_transition\":\"scale\",\"autoplay\":1,\"pause\":0,\"kenburns_transition\":\"top-left\",\"navigation\":\"dotnav\",\"navigation_below\":0,\"navigation_vertical\":0,\"navigation_below_position\":\"center\",\"navigation_position\":\"bottom-center\",\"navigation_below_margin\":\"top\",\"navigation_margin\":\"medium\",\"navigation_breakpoint\":\"s\",\"navigation_color\":\"\",\"thumbnav_wrap\":0,\"thumbnail_width\":100,\"thumbnail_height\":75,\"image_svg_inline\":0,\"image_svg_color\":\"\",\"slidenav_position\":\"default\",\"slidenav_on_hover\":0,\"larger_style\":0,\"slidenav_margin\":\"medium\",\"slidenav_breakpoint\":\"s\",\"slidenav_outside_breakpoint\":\"xl\",\"slidenav_outside_color\":\"\",\"overlay_container\":\"default\",\"overlay_container_padding\":\"small\",\"overlay_margin\":\"\",\"overlay_positions\":\"center-left\",\"overlay_styles\":\"\",\"overlay_background\":\"#ffd49b\",\"overlay_padding\":\"\",\"overlay_width\":\"\",\"overlay_transition\":\"\",\"heading_style\":\"heading-medium\",\"title_decoration\":\"\",\"title_color\":\"\",\"title_text_transform\":\"uppercase\",\"heading_selector\":\"h2\",\"title_margin_top\":\"\",\"use_title_parallax\":0,\"meta_style\":\"\",\"meta_color\":\"\",\"meta_text_transform\":\"\",\"meta_alignment\":\"\",\"meta_element\":\"div\",\"meta_margin_top\":\"\",\"use_meta_parallax\":0,\"content_style\":\"\",\"content_text_transform\":\"\",\"content_margin_top\":\"\",\"use_content_parallax\":0,\"all_button_title\":\"Read more\",\"link_button_style\":\"\",\"button_background\":\"#1e87f0\",\"button_background_hover\":\"#0f7ae5\",\"button_margin_top\":\"medium\",\"use_button_parallax\":0,\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"alignment\":\"\",\"text_breakpoint\":\"\",\"text_alignment_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"max_height\":\"800\",\"font_weight\":\"bolder\",\"kenburns_duration\":\"10\"}}]}]}', '2021-03-13 09:11:05', '777'),
('3', 'Video Button', '{\"id\":1605581841092,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":1,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/vadim-sherbakov-d6eby-faoo0-unsplash.jpg\",\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"50% 50%\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"6,6\",\"columns\":[{\"id\":1605581841090,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605586568788,\"name\":\"video_button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"video_url\":\"https://www.youtube.com/watch?v=5E4jE3es0ak\",\"video_fontsize\":\"28\",\"use_border\":1,\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"#ffc600\",\"padding\":\"30px 28px 30px 32px\",\"background_color\":\"#ffffff\",\"border_radius\":\"100\",\"border_color\":\"rgba(253, 253, 253, 0.5)\",\"border_width\":\"3\"}}]},{\"id\":1605581841091,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/ken-theimer-poe6q48b-5k-unsplash.jpg\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"md\":\"10% 11% 10% 10%\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"overlay\":\"rgba(0, 37, 110, 0.9)\"},\"addons\":[{\"id\":1605586568791,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<span>WHY CHOOSE US</span>Why you like Our University\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"52\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"1px\",\"text\":\"\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_text_color\":\"#ffffff\"}},{\"id\":1605586568794,\"name\":\"accordion\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"panel-modern\",\"openitem\":\"\",\"class\":\"\",\"sp_accordion_item\":[{\"title\":\"We Are The Best Education\",\"icon\":\"\",\"content\":[{\"id\":1605586568,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\",\"dropcap\":0}}]},{\"title\":\"Our Mission & Vission\",\"icon\":\"\",\"content\":[{\"id\":1605598389241,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]},{\"title\":\"Most Successful University\",\"icon\":\"\",\"content\":[{\"id\":1605598390501,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]},{\"title\":\"We Arrange Many Events\",\"icon\":\"\",\"content\":[{\"id\":1605598425647,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]}],\"item_bg\":\"\",\"item_margin\":\"\",\"item_padding\":\"\",\"item_title_bg_color\":\"\",\"item_title_text_color\":\"\",\"item_title_fontsize\":\"\",\"item_title_lineheight\":\"\",\"item_title_letterspace\":\"0px\",\"item_title_padding\":\"\",\"icon_position\":\"\",\"icon_text_color\":\"\",\"icon_fontsize\":\"\",\"icon_margin\":\"\",\"item_content_padding\":\"\",\"active_title_bg_color\":\"\",\"active_title_text_color\":\"\",\"active_icon_rotate\":0,\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]}]}', '2021-03-13 09:11:48', '777'),
('4', 'Testimonial', '{\"id\":1614324552316,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"20px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"5,7\",\"columns\":[{\"id\":1614324552313,\"class_name\":\"col-md-5\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1614324552321,\"name\":\"uiheadinghighlighted\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"before_title\":\"<span>Testimonials</span>Our Lovely \",\"title\":\"Clients\",\"after_title\":\"\",\"heading_style\":\"double-line\",\"title_heading_style\":\"\",\"title_heading_margin\":\"remove\",\"heading_selector\":\"h2\",\"title_letterspace\":\"3px\",\"title_link\":\"\",\"title_fontsize\":\"60\",\"title_lineheight\":\"66\",\"text_transform\":\"uppercase\",\"shapes_width\":\"9\",\"use_link\":0,\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"alignment\":\"\",\"text_breakpoint\":\"\",\"text_alignment_fallback\":\"\",\"animation\":\"slide-bottom-medium\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"#c88948\",\"global_margin_sm\":\"   \",\"global_margin_xs\":\"   \",\"global_padding_sm\":\"   \",\"global_padding_xs\":\"   \"}},{\"id\":1614324552330,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"45\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"text_lineheight\":{\"md\":\"32\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_font_style\":{\"weight\":700}}}]},{\"id\":1614324552366,\"class_name\":\"col-md-7\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1614324552370,\"name\":\"uitestimonialslider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title_addon\":\"\",\"title_heading_style\":\"h3\",\"title_heading_margin\":\"uk-margin\",\"title_heading_decoration\":\"\",\"title_heading_color\":\"\",\"title_heading_selector\":\"h3\",\"ui_testimonialslider_item\":[{\"title\":\"Peter Holland\",\"company\":\"Director of Pet Shop\",\"client_review\":\"\",\"message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"link\":\"\",\"avatar\":\"images/avatars/05_team.png\"},{\"title\":\"Patrick Oliver\",\"company\":\"UI/UX Designer, London\",\"client_review\":\"\",\"message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"link\":\"\",\"avatar\":\"images/avatars/06_team.png\"},{\"title\":\"Leanne Simpson\",\"company\":\"Marketing Online\",\"client_review\":\"\",\"message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"link\":\"\",\"avatar\":\"images/avatars/04_testimonial.jpg\"},{\"title\":\"Mary Lane\",\"company\":\"C.E.O at TemPlaza.com\",\"client_review\":\"\",\"message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"link\":\"\",\"avatar\":\"images/avatars/03_testimonial.jpg\"}],\"ts_phone_portrait\":\"1-1\",\"ts_phone_landscape\":\"\",\"ts_tablet_landscape\":\"1-2\",\"ts_desktop\":\"\",\"ts_large_screens\":\"\",\"grid_column_gap\":\"\",\"divider\":0,\"header_alignment\":\"\",\"header_margin_top\":\"\",\"icon_color\":\"#fba311\",\"icon_rating\":\"\",\"rating_alignment\":\"\",\"card_styles\":\"default\",\"panel_link\":0,\"card_background\":\"#1e87f0\",\"card_size\":\"\",\"card_content_padding\":\"\",\"card_width\":\"\",\"slidesets\":0,\"center_slide\":0,\"finite_slide\":0,\"autoplay\":0,\"pause\":0,\"navigation\":\"\",\"navigation_position\":\"center\",\"navigation_margin\":\"uk-margin-top\",\"navigation_breakpoint\":\"s\",\"navigation_color\":\"\",\"slidenav_position\":\"top-right\",\"slidenav_margin\":\"medium\",\"slidenav_breakpoint\":\"s\",\"slidenav_color\":\"\",\"slidenav_outside_breakpoint\":\"xl\",\"slidenav_outside_color\":\"\",\"slidenav_on_hover\":0,\"larger_style\":0,\"image_position\":\"\",\"image_grid_width\":\"auto\",\"image_grid_column_gap\":\"small\",\"image_grid_breakpoint\":\"m\",\"vertical_alignment\":1,\"image_margin_top\":\"\",\"image_link\":0,\"avatar_width\":90,\"avatar_shape\":\"uk-border-circle\",\"image_svg_inline\":0,\"image_svg_color\":\"\",\"title_style\":\"\",\"title_text_color\":\"\",\"title_text_transform\":\"\",\"link_title\":0,\"title_hover_style\":\"reset\",\"heading_selector\":\"h3\",\"title_margin_top\":\"remove\",\"meta_style\":\"text-meta\",\"meta_text_transform\":\"\",\"meta_text_color\":\"\",\"meta_element\":\"div\",\"meta_margin_top\":\"remove\",\"content_style\":\"\",\"content_dropcap\":0,\"content_column\":\"\",\"content_column_divider\":0,\"content_column_breakpoint\":\"m\",\"content_text_transform\":\"\",\"content_margin_top\":\"\",\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"text_alignment\":\"\",\"text_breakpoint\":\"\",\"text_alignment_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]}]}', '2021-03-15 08:42:42', '777');
/**ABDB**/INSERT INTO `#__sppagebuilder_sections`  VALUES 
('5', 'Services', '{\"id\":1615863542892,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"100px 0px 100px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"8,4\",\"columns\":[{\"id\":1615863542890,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"z-index-2\"},\"addons\":[{\"id\":1615864620866,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"6,6\",\"visibility\":true,\"columns\":[{\"id\":1615864620867,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615863542895,\"name\":\"tinyslider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"interval\":5,\"overlay\":\"\",\"message_background\":\"#4184d8\",\"height\":{\"md\":\"600\",\"sm\":\"400\",\"xs\":\"400\"},\"controls\":0,\"bullet_border_color\":\"\",\"bullet_active_bg_color\":\"\",\"bullet_position\":\"bottom-center\",\"arrow_controls\":0,\"arrow_background\":\"\",\"arrow_color\":\"\",\"arrow_hover_background\":\"\",\"arrow_hover_color\":\"\",\"sp_tinyslider_item\":[{\"title\":\"Road Freight\",\"message\":\"Logistics is largest global freight forwarders operating within a worldwide network.\",\"content_position\":\"bottom-left\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"image\":\"images/ivan-bandura-n_fdxbxwqmc-unsplash.jpg\"},{\"title\":\"For Local\",\"message\":\"Logistics is largest global freight forwarders operating within a worldwide network.\",\"content_position\":\"bottom-left\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"image\":\"images/roman-fox-7-zz6qapty4-unsplash.jpg\"}],\"title_font_size\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_line_height\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0px\",\"content_fontsize\":{\"md\":16,\"sm\":16,\"xs\":16},\"content_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_padding\":{\"md\":\"30px 30px 30px 30px\",\"sm\":\"30px 30px 30px 30px\",\"xs\":\"20px 20px 20px 20px\"},\"content_alignment\":\"center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"content_margin\":{\"md\":\"0 10% 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"title_color\":\"#ffffff\",\"content_color\":\"#ffffff\"}}]},{\"id\":1615864620870,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"default\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0,\"background_type\":\"image\",\"background_image\":\"images/ernesto-leon-4h_i-hrjkya-unsplash.jpg\",\"items_align_center\":1,\"items_content_alignment\":\"center\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"inherit\"},\"addons\":[{\"id\":1615863542893,\"name\":\"video_button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"video_url\":\"https://www.youtube.com/watch?v=6p7_lU6GM8w\",\"video_fontsize\":\"28\",\"use_border\":1,\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"rgb(65, 132, 216)\",\"padding\":\"30px 28px 30px 32px\",\"background_color\":\"#ffffff\",\"border_radius\":\"100\",\"border_color\":\"rgba(253, 253, 253, 0.5)\",\"border_width\":\"3\"}}]}]},{\"id\":1615879050653,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1615879050654,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615879050659,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Overview\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt. Aenean quis massa uada mi elementum elementum. Nec sapien convallis vulputate rhoncus vel dui.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]}]},{\"id\":1615879050664,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"6,6\",\"visibility\":true,\"columns\":[{\"id\":1615879050665,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615879050690,\"name\":\"uicard\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title_addon\":\"\",\"title_heading_style\":\"h3\",\"title_heading_margin\":\"uk-margin\",\"title_heading_decoration\":\"\",\"title_heading_color\":\"\",\"title_heading_selector\":\"h3\",\"card_title\":\"36000\",\"card_content\":\"Tons of air freight annually\",\"alt_text\":\"Image ALT\",\"button_title\":\"Read more\",\"card_style\":\"default\",\"panel_link\":0,\"card_background\":\"#1e87f0\",\"card_size\":\"\",\"image_padding\":0,\"card_content_padding\":\"\",\"heading_style\":\"heading-small\",\"link_title\":0,\"title_hover_style\":\"reset\",\"title_decoration\":\"\",\"title_color\":\"\",\"title_text_transform\":\"\",\"heading_selector\":\"h3\",\"title_align\":\"\",\"title_grid_width\":\"1-2\",\"title_grid_column_gap\":\"\",\"title_grid_row_gap\":\"\",\"title_breakpoint\":\"m\",\"title_margin_top\":\"small\",\"meta_style\":\"\",\"meta_color\":\"\",\"meta_text_transform\":\"\",\"meta_alignment\":\"top\",\"meta_element\":\"div\",\"meta_margin_top\":\"\",\"content_style\":\"\",\"content_dropcap\":0,\"content_column\":\"\",\"content_column_divider\":0,\"content_column_breakpoint\":\"m\",\"content_text_transform\":\"\",\"content_margin_top\":\"small\",\"image_border\":\"\",\"image_box_shadow\":\"\",\"image_link\":0,\"image_transition\":\"\",\"image_hover_box_shadow\":\"\",\"card_alignment\":\"top\",\"grid_width\":\"1-2\",\"image_grid_column_gap\":\"\",\"image_grid_row_gap\":\"\",\"grid_breakpoint\":\"m\",\"vertical_alignment\":0,\"image_margin_top\":\"\",\"image_svg_inline\":0,\"image_svg_color\":\"\",\"button_style\":\"\",\"button_background\":\"#1e87f0\",\"button_background_hover\":\"#0f7ae5\",\"link_button_size\":\"\",\"button_margin_top\":\"\",\"label_text\":\"\",\"label_styles\":\"\",\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"alignment\":\"\",\"text_breakpoint\":\"\",\"text_alignment_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"meta\":\"WE HANDLED\",\"custom_title_color\":\"rgb(65, 132, 216)\"}}]},{\"id\":1615879050668,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1615879050721,\"name\":\"uicard\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title_addon\":\"\",\"title_heading_style\":\"h3\",\"title_heading_margin\":\"uk-margin\",\"title_heading_decoration\":\"\",\"title_heading_color\":\"\",\"title_heading_selector\":\"h3\",\"card_title\":\"148+\",\"card_content\":\"International gateways\",\"alt_text\":\"Image ALT\",\"button_title\":\"Read more\",\"card_style\":\"primary\",\"panel_link\":0,\"card_background\":\"#1e87f0\",\"card_size\":\"\",\"image_padding\":0,\"card_content_padding\":\"\",\"heading_style\":\"heading-small\",\"link_title\":0,\"title_hover_style\":\"reset\",\"title_decoration\":\"\",\"title_color\":\"\",\"title_text_transform\":\"\",\"heading_selector\":\"h3\",\"title_align\":\"\",\"title_grid_width\":\"1-2\",\"title_grid_column_gap\":\"\",\"title_grid_row_gap\":\"\",\"title_breakpoint\":\"m\",\"title_margin_top\":\"small\",\"meta_style\":\"\",\"meta_color\":\"\",\"meta_text_transform\":\"\",\"meta_alignment\":\"top\",\"meta_element\":\"div\",\"meta_margin_top\":\"\",\"content_style\":\"\",\"content_dropcap\":0,\"content_column\":\"\",\"content_column_divider\":0,\"content_column_breakpoint\":\"m\",\"content_text_transform\":\"\",\"content_margin_top\":\"small\",\"image_border\":\"\",\"image_box_shadow\":\"\",\"image_link\":0,\"image_transition\":\"\",\"image_hover_box_shadow\":\"\",\"card_alignment\":\"top\",\"grid_width\":\"1-2\",\"image_grid_column_gap\":\"\",\"image_grid_row_gap\":\"\",\"grid_breakpoint\":\"m\",\"vertical_alignment\":0,\"image_margin_top\":\"\",\"image_svg_inline\":0,\"image_svg_color\":\"\",\"button_style\":\"\",\"button_background\":\"#1e87f0\",\"button_background_hover\":\"#0f7ae5\",\"link_button_size\":\"\",\"button_margin_top\":\"\",\"label_text\":\"\",\"label_styles\":\"\",\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"alignment\":\"\",\"text_breakpoint\":\"\",\"text_alignment_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"meta\":\"WE COVERED\",\"custom_title_color\":\"\"}}]}]},{\"id\":1615879050740,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12,4,4,4\",\"visibility\":true,\"columns\":[{\"id\":1615879050741,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615879050742,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Services We Provide\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1615879050751,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1615879050758,\"name\":\"uicard\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title_addon\":\"\",\"title_heading_style\":\"h3\",\"title_heading_margin\":\"uk-margin\",\"title_heading_decoration\":\"\",\"title_heading_color\":\"\",\"title_heading_selector\":\"h3\",\"card_title\":\"Global Shipping\",\"card_content\":\"Indignation &amp; dislike men who are so beguiled demoralized by the charms of pleasures of the moment, so blinded by desire.\",\"alt_text\":\"Image ALT\",\"button_title\":\"Read more\",\"card_style\":\"default\",\"panel_link\":0,\"card_background\":\"#1e87f0\",\"card_size\":\"uk-card-small\",\"image_padding\":0,\"card_content_padding\":\"\",\"heading_style\":\"\",\"link_title\":0,\"title_hover_style\":\"reset\",\"title_decoration\":\"\",\"title_color\":\"\",\"title_text_transform\":\"\",\"heading_selector\":\"h4\",\"title_align\":\"\",\"title_grid_width\":\"1-2\",\"title_grid_column_gap\":\"\",\"title_grid_row_gap\":\"\",\"title_breakpoint\":\"m\",\"title_margin_top\":\"\",\"meta_style\":\"\",\"meta_color\":\"\",\"meta_text_transform\":\"\",\"meta_alignment\":\"\",\"meta_element\":\"div\",\"meta_margin_top\":\"\",\"content_style\":\"\",\"content_dropcap\":0,\"content_column\":\"\",\"content_column_divider\":0,\"content_column_breakpoint\":\"m\",\"content_text_transform\":\"\",\"content_margin_top\":\"small\",\"image_border\":\"\",\"image_box_shadow\":\"\",\"image_link\":0,\"image_transition\":\"\",\"image_hover_box_shadow\":\"\",\"card_alignment\":\"top\",\"grid_width\":\"1-2\",\"image_grid_column_gap\":\"\",\"image_grid_row_gap\":\"\",\"grid_breakpoint\":\"m\",\"vertical_alignment\":0,\"image_margin_top\":\"\",\"image_svg_inline\":0,\"image_svg_color\":\"\",\"button_style\":\"\",\"button_background\":\"#1e87f0\",\"button_background_hover\":\"#0f7ae5\",\"link_button_size\":\"\",\"button_margin_top\":\"\",\"label_text\":\"\",\"label_styles\":\"\",\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"alignment\":\"\",\"text_breakpoint\":\"\",\"text_alignment_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":\"images/project-19.jpg\"}}]},{\"id\":1615879050752,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1615879050771,\"name\":\"uicard\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title_addon\":\"\",\"title_heading_style\":\"h3\",\"title_heading_margin\":\"uk-margin\",\"title_heading_decoration\":\"\",\"title_heading_color\":\"\",\"title_heading_selector\":\"h3\",\"card_title\":\"Storage\",\"card_content\":\"Indignation &amp; dislike men who are so beguiled demoralized by the charms of pleasures of the moment, so blinded by desire.\",\"alt_text\":\"Image ALT\",\"button_title\":\"Read more\",\"card_style\":\"default\",\"panel_link\":0,\"card_background\":\"#1e87f0\",\"card_size\":\"uk-card-small\",\"image_padding\":0,\"card_content_padding\":\"\",\"heading_style\":\"\",\"link_title\":0,\"title_hover_style\":\"reset\",\"title_decoration\":\"\",\"title_color\":\"\",\"title_text_transform\":\"\",\"heading_selector\":\"h4\",\"title_align\":\"\",\"title_grid_width\":\"1-2\",\"title_grid_column_gap\":\"\",\"title_grid_row_gap\":\"\",\"title_breakpoint\":\"m\",\"title_margin_top\":\"\",\"meta_style\":\"\",\"meta_color\":\"\",\"meta_text_transform\":\"\",\"meta_alignment\":\"\",\"meta_element\":\"div\",\"meta_margin_top\":\"\",\"content_style\":\"\",\"content_dropcap\":0,\"content_column\":\"\",\"content_column_divider\":0,\"content_column_breakpoint\":\"m\",\"content_text_transform\":\"\",\"content_margin_top\":\"small\",\"image_border\":\"\",\"image_box_shadow\":\"\",\"image_link\":0,\"image_transition\":\"\",\"image_hover_box_shadow\":\"\",\"card_alignment\":\"top\",\"grid_width\":\"1-2\",\"image_grid_column_gap\":\"\",\"image_grid_row_gap\":\"\",\"grid_breakpoint\":\"m\",\"vertical_alignment\":0,\"image_margin_top\":\"\",\"image_svg_inline\":0,\"image_svg_color\":\"\",\"button_style\":\"\",\"button_background\":\"#1e87f0\",\"button_background_hover\":\"#0f7ae5\",\"link_button_size\":\"\",\"button_margin_top\":\"\",\"label_text\":\"\",\"label_styles\":\"\",\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"alignment\":\"\",\"text_breakpoint\":\"\",\"text_alignment_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":\"images/project-20.jpg\"}}]},{\"id\":1615879050753,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1615879050776,\"name\":\"uicard\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title_addon\":\"\",\"title_heading_style\":\"h3\",\"title_heading_margin\":\"uk-margin\",\"title_heading_decoration\":\"\",\"title_heading_color\":\"\",\"title_heading_selector\":\"h3\",\"card_title\":\"Fast Delivery\",\"card_content\":\"Indignation &amp; dislike men who are so beguiled demoralized by the charms of pleasures of the moment, so blinded by desire.\",\"alt_text\":\"Image ALT\",\"button_title\":\"Read more\",\"card_style\":\"default\",\"panel_link\":0,\"card_background\":\"#1e87f0\",\"card_size\":\"uk-card-small\",\"image_padding\":0,\"card_content_padding\":\"\",\"heading_style\":\"\",\"link_title\":0,\"title_hover_style\":\"reset\",\"title_decoration\":\"\",\"title_color\":\"\",\"title_text_transform\":\"\",\"heading_selector\":\"h4\",\"title_align\":\"\",\"title_grid_width\":\"1-2\",\"title_grid_column_gap\":\"\",\"title_grid_row_gap\":\"\",\"title_breakpoint\":\"m\",\"title_margin_top\":\"\",\"meta_style\":\"\",\"meta_color\":\"\",\"meta_text_transform\":\"\",\"meta_alignment\":\"\",\"meta_element\":\"div\",\"meta_margin_top\":\"\",\"content_style\":\"\",\"content_dropcap\":0,\"content_column\":\"\",\"content_column_divider\":0,\"content_column_breakpoint\":\"m\",\"content_text_transform\":\"\",\"content_margin_top\":\"small\",\"image_border\":\"\",\"image_box_shadow\":\"\",\"image_link\":0,\"image_transition\":\"\",\"image_hover_box_shadow\":\"\",\"card_alignment\":\"top\",\"grid_width\":\"1-2\",\"image_grid_column_gap\":\"\",\"image_grid_row_gap\":\"\",\"grid_breakpoint\":\"m\",\"vertical_alignment\":0,\"image_margin_top\":\"\",\"image_svg_inline\":0,\"image_svg_color\":\"\",\"button_style\":\"\",\"button_background\":\"#1e87f0\",\"button_background_hover\":\"#0f7ae5\",\"link_button_size\":\"\",\"button_margin_top\":\"\",\"label_text\":\"\",\"label_styles\":\"\",\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"alignment\":\"\",\"text_breakpoint\":\"\",\"text_alignment_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":\"images/project-17.jpg\"}}]}]},{\"id\":1615879050787,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12,3,3,3,3\",\"visibility\":true,\"columns\":[{\"id\":1615879050788,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615879050789,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Effortless Shipping With Transida\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt. Aenean quis massa uada mi elementum elementum. Nec sapien convallis vulputate rhoncus vel dui.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1615879050796,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"default\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"items_align_center\":1,\"padding\":{\"md\":\"35px 20px 35px 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":1,\"border_width\":{\"md\":\"2\",\"sm\":\"\",\"xs\":\"\"},\"border_color\":\"#dddddd\",\"boder_style\":\"dashed\",\"items_content_alignment\":\"center\"},\"addons\":[{\"id\":1615879050804,\"name\":\"linearicon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"link\":\"\",\"size\":{\"md\":\"65\"},\"width\":{\"md\":\"70\"},\"height\":{\"md\":\"70\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"name\":\"lnr-wallet\",\"color\":\"rgb(65, 132, 216)\"}},{\"id\":1615879050809,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Low Cost\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_margin_bottom\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"}}}]},{\"id\":1615879050797,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"default\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"items_align_center\":0,\"padding\":{\"md\":\"35px 20px 35px 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":1,\"border_width\":{\"md\":\"2\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"border_color\":\"#dddddd\",\"boder_style\":\"dashed\"},\"addons\":[{\"id\":1615879050832,\"name\":\"linearicon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"link\":\"\",\"size\":{\"md\":\"65\"},\"width\":{\"md\":\"70\"},\"height\":{\"md\":\"70\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"name\":\"lnr-ship\",\"color\":\"rgb(65, 132, 216)\"}},{\"id\":1615879050837,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Fast Delivery\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_margin_bottom\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"}}}]},{\"id\":1615879050798,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"default\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"items_align_center\":0,\"padding\":{\"md\":\"35px 20px 35px 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":1,\"border_width\":{\"md\":\"2\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"border_color\":\"#dddddd\",\"boder_style\":\"dashed\"},\"addons\":[{\"id\":1615879050842,\"name\":\"linearicon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"link\":\"\",\"size\":{\"md\":\"65\"},\"width\":{\"md\":\"70\"},\"height\":{\"md\":\"70\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"name\":\"lnr-timer\",\"color\":\"rgb(65, 132, 216)\"}},{\"id\":1615879050852,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Time Monitor\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_margin_bottom\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"}}}]},{\"id\":1615879050799,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"default\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"padding\":{\"md\":\"35px 20px 35px 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":1,\"border_radius\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"border_width\":{\"md\":\"2\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"border_color\":\"#dddddd\",\"boder_style\":\"dashed\"},\"addons\":[{\"id\":1615879050847,\"name\":\"linearicon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"link\":\"\",\"size\":{\"md\":\"65\"},\"width\":{\"md\":\"70\"},\"height\":{\"md\":\"70\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"name\":\"lnr-headset\",\"color\":\"rgb(65, 132, 216)\"}},{\"id\":1615879050857,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Support 24/7\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_margin_bottom\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"}}}]}]}]},{\"id\":1615863542891,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/fatima-garcia-hzfifihonvy-unsplash.jpg\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1615864620910,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"30px 30px 10px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":1,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"background_color\":\"#f5f5f5\",\"row_border_width\":{\"md\":\"3px 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"row_border_color\":\"rgb(65, 132, 216)\"},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1615864620911,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615864620956,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Services\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1615864620918,\"name\":\"navigation\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"sp_link_list_item\":[{\"title\":\"Air Freight\",\"active\":0,\"class\":\"sppb-btn-block mb-2\",\"url\":\"index.php/en/services/air-freight\",\"icon\":\"fas fa-plane\"},{\"title\":\"Ocean Freight\",\"active\":0,\"class\":\"sppb-btn-block mb-2\",\"url\":\"index.php/en/services/ocean-freight\",\"icon\":\"fas fa-ship\"},{\"title\":\"Road Freight\",\"active\":0,\"class\":\"sppb-btn-block mb-2\",\"url\":\"index.php/en/services/road-freight\",\"icon\":\"fas fa-truck-moving\"},{\"title\":\"Train Freight\",\"active\":0,\"class\":\"sppb-btn-block mb-2\",\"url\":\"index.php/en/services/train-freight\",\"icon\":\"fas fa-train\"}],\"scroll_to\":0,\"sticky_menu\":0,\"type\":\"list\",\"align\":\"left\",\"link_bg_hover\":\"#4084d8\",\"link_border_radius\":3,\"link_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"link_lineheight\":\"\",\"link_letterspace\":\"0\",\"link_text_transform\":\"none\",\"link_padding\":{\"md\":\"12px 20px 12px 20px\",\"sm\":\"7px 17px 7px 17px\",\"xs\":\"7px 17px 7px 17px\"},\"link_color_active\":\"#ffffff\",\"link_bg_active\":\"#4084D8\",\"link_border_radius_active\":3,\"icon_position\":\"left\",\"icon_size\":\"\",\"responsive_menu\":0,\"responsive_bar_bg\":\"rgba(0, 0, 0, .1)\",\"responsive_bar_bg_active\":\"#22b8f0\",\"responsive_bar_color\":\"#000\",\"responsive_bar_color_active\":\"#fff\",\"global_class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"link_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"link_bg\":\"#ffffff\",\"link_color\":\"#353535\",\"link_color_hover\":\"#ffffff\"}}]}]},{\"id\":1615871365202,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"30px 30px 50px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":1,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"background_color\":\"rgb(65, 132, 216)\",\"row_border_width\":{\"md\":\"3px 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"row_border_color\":\"rgb(37, 61, 107)\"},\"layout\":\"12,6,6\",\"visibility\":true,\"columns\":[{\"id\":1615871365203,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615871365204,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Documentations\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"global_text_color\":\"#ffffff\",\"title_text_color\":\"#ffffff\"}}]},{\"id\":1615879050556,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"default\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"items_align_center\":1,\"padding\":{\"md\":\"30px 0px 5px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0,\"background_type\":\"color\",\"background\":\"#ffffff\",\"items_content_alignment\":\"center\"},\"addons\":[{\"id\":1615879050566,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fas fa-file-pdf\",\"link\":\"images/Learning_materials.pdf\",\"size\":{\"md\":\"70\"},\"width\":{\"md\":\"80\"},\"height\":{\"md\":\"90\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"target\":\"_blank\"}},{\"id\":1615879050576,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Get Started\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1615879050557,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"default\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"items_align_center\":1,\"padding\":{\"md\":\"30px 0px 5px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0,\"background_type\":\"color\",\"background\":\"#ffffff\",\"items_content_alignment\":\"center\"},\"addons\":[{\"id\":1615879050608,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fas fa-file-pdf\",\"link\":\"images/Learning_materials.pdf\",\"size\":{\"md\":\"70\"},\"width\":{\"md\":\"80\"},\"height\":{\"md\":\"90\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"target\":\"_blank\"}},{\"id\":1615879050585,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"TAX Infor\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]}]},{\"id\":1615879050896,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"30px 30px 10px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":1,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"background_color\":\"#f5f5f5\",\"row_border_width\":{\"md\":\"3px 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"row_border_color\":\"rgb(65, 132, 216)\"},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1615879050897,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615879050898,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Get A Quote\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Get immediate quotes &amp; book shipment.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1615879050912,\"name\":\"form_builder\",\"visibility\":true,\"settings\":{\"admin_label\":\"Form Builder\",\"class\":\"\",\"form_elements\":\"fstyle\",\"sp_form_builder_item\":[{\"field_is_required\":1,\"field_type\":\"text\",\"title\":\"YOUR NAME\",\"field_required_star\":1,\"field_name\":\"your-name\",\"field_placeholder\":\"Your Name\",\"field_width\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"}},{\"field_is_required\":1,\"field_type\":\"text\",\"title\":\"YOUR EMAIL\",\"field_required_star\":1,\"field_name\":\"your-email\",\"field_placeholder\":\"Your Email\",\"field_width\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"}},{\"title\":\"ORIGIN COUNTRY\",\"field_name\":\"origin-country\",\"field_placeholder\":\"\",\"field_type\":\"select\",\"field_width\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"},\"field_is_required\":1,\"field_required_star\":1,\"sp_form_builder_inner_item_select\":[{\"is_selected\":1,\"title\":\"United Stade\"},{\"is_selected\":0,\"title\":\"United Kingdom\"},{\"is_selected\":0,\"title\":\"Germany\"},{\"is_selected\":0,\"title\":\"France\"},{\"is_selected\":0,\"title\":\"Italy\"}]},{\"title\":\"DESTINATION COUNTRY\",\"field_name\":\"destination-country\",\"field_placeholder\":\"\",\"field_type\":\"select\",\"field_width\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"},\"field_is_required\":1,\"field_required_star\":1,\"sp_form_builder_inner_item_select\":[{\"is_selected\":1,\"title\":\"United Stade\"},{\"is_selected\":0,\"title\":\"United Kingdom\"},{\"is_selected\":0,\"title\":\"Germany\"},{\"is_selected\":0,\"title\":\"France\"},{\"is_selected\":0,\"title\":\"Italy\"}]}],\"additional_header\":\"Reply-To: {{email}}\\nReply-name: {{first-name}} {{last-name}}\\nCc: {{email}}\",\"email_subject\":\"{{subject}} | {{email}} | {{site-name}}\",\"email_template\":\"<p><strong>From:</strong>{{first-name}} {{last-name}}</p>\\n<p><strong>Email:</strong>{{email}}</p>\\n<p><strong>Subject:</strong>{{subject}}</p>\\n<p><strong>Message:</strong>{{message}}</p>\",\"required_field_message\":\"Please fill the required field.\",\"success_message\":\"Email successfully sent!\",\"failed_message\":\"Email sent failed, fill required field and try again!\",\"enable_redirect\":0,\"enable_captcha\":0,\"captcha_type\":\"default\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"enable_policy\":0,\"policy_text\":\"I agree with the <a href=\\\"#\\\">Terms of Use</a> and <a href=\\\"#\\\">Privacy Policy</a> and I declare that I have read the information that is required in accordance with <a href=\\\"http://eur-lex.europa.eu/legal-content/EN/TXT/?uri=uriserv:OJ.L_.2016.119.01.0001.01.ENG&amp;toc=OJ:L:2016:119:TOC\\\" target=\\\"_blank\\\">Article 13 of GDPR.</a>\",\"btn_text\":\"GET A QUOTE\",\"btn_position\":\"sppb-text-left\",\"btn_icon_position\":\"left\",\"sp_form_style_option\":\"btn_style\",\"field_gutter\":{\"md\":15,\"sm\":15,\"xs\":15},\"field_horizontal_space\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"field_font_size\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"input_height\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"textarea_height\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"label_font_size\":{\"md\":\"12\",\"sm\":\"\",\"xs\":\"\"},\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_size\":\"\",\"btn_shape\":\"rounded\",\"btn_fontsize\":{\"md\":16},\"btn_letterspace\":\"0px\",\"button_status\":\"hover\",\"btn_background_color\":\"#4184d8\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#679ee2\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"btn_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"btn_padding\":{\"md\":\"12px 22px 12px 22px\",\"sm\":\"   \",\"xs\":\"   \"},\"btn_class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"btn_icon\":\"fas fa-arrow-alt-circle-right\",\"field_border_width\":\"   \",\"field_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"label_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"label_color\":\"#8c8c8c\"}}]}]}]}]}', '2021-03-17 02:56:22', '777');
/**ABDB**/INSERT INTO `#__sppagebuilder_sections`  VALUES 
('6', 'Testimonial', '{\"id\":1506350355448,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"separator1\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"separator2\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":0,\"no_gutter\":0,\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"120px 0px 90px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"\",\"background_image\":\"images/tz_logistics/pexels-chanaka-906494.jpg\",\"background_parallax\":0,\"overlay\":\"rgba(35, 42, 45, 0.9)\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"external_background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"background_external_video\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"columns_align_center\":0,\"row_border\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"background_type\":\"image\",\"overlay_type\":\"overlay_color\"},\"layout\":\"4,8,12\",\"columns\":[{\"id\":1503546281507,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":\"\",\"boxshadow\":\"\",\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"separator\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"600\",\"animationdelay\":\"500\"},\"addons\":[{\"id\":1615797767877,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"TESTIMONIALS\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"45\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Phasellus porttitor leo a augue.\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"15\",\"sm\":\"\",\"xs\":\"\"},\"text_lineheight\":{\"md\":\"32\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_font_style\":{\"weight\":700},\"title_text_color\":\"#ffffff\",\"global_text_color\":\"#ffffff\"}},{\"id\":1615862941221,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"View More\",\"alignment\":\"sppb-text-left\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"md\":16},\"button_status\":\"hover\",\"background_color\":\"rgb(65, 132, 216)\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#5e98e0\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"md\":\"10px 20px 12px 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"url\":\"./index.php/en/about-us/testimonials\"}}]},{\"id\":1615797767874,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{\"default\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"items_align_center\":0,\"animation\":\"fadeInRight\",\"animationduration\":\"600\",\"animationdelay\":\"400\"},\"addons\":[{\"id\":1615797767879,\"name\":\"uitestimonialslider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title_addon\":\"\",\"title_heading_style\":\"h3\",\"title_heading_margin\":\"uk-margin\",\"title_heading_decoration\":\"\",\"title_heading_color\":\"\",\"title_heading_selector\":\"h3\",\"ui_testimonialslider_item\":[{\"title\":\"Peter Holland\",\"company\":\"Director of Pet Shop\",\"client_review\":\"\",\"message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"link\":\"\",\"avatar\":\"images/avatars/05_team.png\"},{\"title\":\"Patrick Oliver\",\"company\":\"UI/UX Designer, London\",\"client_review\":\"\",\"message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"link\":\"\",\"avatar\":\"images/avatars/06_team.png\"},{\"title\":\"Leanne Simpson\",\"company\":\"Marketing Online\",\"client_review\":\"\",\"message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"link\":\"\",\"avatar\":\"images/avatars/04_testimonial.jpg\"},{\"title\":\"Mary Lane\",\"company\":\"C.E.O at TemPlaza.com\",\"client_review\":\"\",\"message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"link\":\"\",\"avatar\":\"images/avatars/03_testimonial.jpg\"}],\"ts_phone_portrait\":\"1-1\",\"ts_phone_landscape\":\"\",\"ts_tablet_landscape\":\"1-2\",\"ts_desktop\":\"\",\"ts_large_screens\":\"\",\"grid_column_gap\":\"\",\"divider\":0,\"header_alignment\":\"\",\"header_margin_top\":\"\",\"icon_color\":\"#fba311\",\"icon_rating\":\"\",\"rating_alignment\":\"\",\"card_styles\":\"default\",\"panel_link\":0,\"card_background\":\"#1e87f0\",\"card_size\":\"\",\"card_content_padding\":\"\",\"card_width\":\"\",\"slidesets\":0,\"center_slide\":0,\"finite_slide\":0,\"autoplay\":0,\"pause\":0,\"navigation\":\"\",\"navigation_position\":\"center\",\"navigation_margin\":\"uk-margin-top\",\"navigation_breakpoint\":\"s\",\"navigation_color\":\"\",\"slidenav_position\":\"top-right\",\"slidenav_margin\":\"medium\",\"slidenav_breakpoint\":\"s\",\"slidenav_color\":\"\",\"slidenav_outside_breakpoint\":\"xl\",\"slidenav_outside_color\":\"\",\"slidenav_on_hover\":0,\"larger_style\":0,\"image_position\":\"\",\"image_grid_width\":\"auto\",\"image_grid_column_gap\":\"small\",\"image_grid_breakpoint\":\"m\",\"vertical_alignment\":1,\"image_margin_top\":\"\",\"image_link\":0,\"avatar_width\":90,\"avatar_shape\":\"uk-border-circle\",\"image_svg_inline\":0,\"image_svg_color\":\"\",\"title_style\":\"\",\"title_text_color\":\"\",\"title_text_transform\":\"\",\"link_title\":0,\"title_hover_style\":\"reset\",\"heading_selector\":\"h3\",\"title_margin_top\":\"remove\",\"meta_style\":\"text-meta\",\"meta_text_transform\":\"\",\"meta_text_color\":\"\",\"meta_element\":\"div\",\"meta_margin_top\":\"remove\",\"content_style\":\"\",\"content_dropcap\":0,\"content_column\":\"\",\"content_column_divider\":0,\"content_column_breakpoint\":\"m\",\"content_text_transform\":\"\",\"content_margin_top\":\"\",\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"text_alignment\":\"\",\"text_breakpoint\":\"\",\"text_alignment_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1615797767917,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1615797767928,\"name\":\"uidivider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"uk-hr\",\"html_selector\":\"hr\",\"alignment\":\"\",\"alignment_breakpoint\":\"\",\"alignment_fallback\":\"\",\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"30px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"border_width\":\"1\",\"border_color\":\"rgba(221, 221, 221, 0.1)\"}},{\"id\":1615797767920,\"name\":\"clients\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"count\":\"sppb-col-sm-2\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"sp_clients_item\":[{\"title\":\"Client 1\",\"image\":\"images/xlogo-1.png\",\"url_same_window\":0},{\"title\":\"Client 1\",\"image\":\"images/xlogo-2.png\",\"url_same_window\":0},{\"title\":\"Client 1\",\"image\":\"images/xlogo-3.png\",\"url_same_window\":0},{\"title\":\"Client 1\",\"image\":\"images/xlogo-4.png\",\"url_same_window\":0},{\"title\":\"Client 1\",\"image\":\"images/xlogo-5.png\",\"url_same_window\":0},{\"title\":\"Client 1\",\"image\":\"images/xlogo-1.png\",\"url_same_window\":0}],\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1615797767923,\"name\":\"uidivider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"uk-hr\",\"html_selector\":\"hr\",\"alignment\":\"\",\"alignment_breakpoint\":\"\",\"alignment_fallback\":\"\",\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"border_width\":\"1\",\"border_color\":\"rgba(221, 221, 221, 0.1)\"}}]}]}', '2021-03-17 03:29:45', '777'),
('7', 'Request A Quote', '{\"id\":1615863542892,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"100px 0px 100px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"8,4\",\"columns\":[{\"id\":1615863542890,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"z-index-2\"},\"addons\":[{\"id\":1615879050653,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1615879050654,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615879050659,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Overview\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt. Aenean quis massa uada mi elementum elementum. Nec sapien convallis vulputate rhoncus vel dui.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1615879050912,\"name\":\"form_builder\",\"visibility\":true,\"settings\":{\"admin_label\":\"Form Builder\",\"class\":\"\",\"form_elements\":\"felements\",\"sp_form_builder_item\":[{\"field_is_required\":1,\"field_type\":\"select\",\"title\":\"FREIGHT TYPE\",\"field_required_star\":1,\"field_name\":\"freight-type\",\"field_width\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"},\"sp_form_builder_inner_item_select\":[{\"is_selected\":1,\"title\":\"Air Freight\"},{\"is_selected\":0,\"title\":\"Ocean Freight\"},{\"is_selected\":0,\"title\":\"Train Freight\"},{\"is_selected\":0,\"title\":\"Read Freight\"}]},{\"title\":\"PICKUP ADDRESS\",\"field_name\":\"pickup-address\",\"field_placeholder\":\"\",\"field_type\":\"select\",\"field_width\":{\"md\":\"50\",\"sm\":\"\",\"xs\":\"\"},\"field_is_required\":1,\"field_required_star\":1,\"sp_form_builder_inner_item_select\":[{\"is_selected\":1,\"title\":\"United Stade\"},{\"is_selected\":0,\"title\":\"United Kingdom\"},{\"is_selected\":0,\"title\":\"Germany\"},{\"is_selected\":0,\"title\":\"France\"},{\"is_selected\":0,\"title\":\"Italy\"}]},{\"title\":\"DROP ADDRESS\",\"field_name\":\"drop-address\",\"field_placeholder\":\"\",\"field_type\":\"select\",\"field_width\":{\"md\":\"50\",\"sm\":\"\",\"xs\":\"\"},\"field_is_required\":1,\"field_required_star\":1,\"sp_form_builder_inner_item_select\":[{\"is_selected\":1,\"title\":\"United Stade\"},{\"is_selected\":0,\"title\":\"United Kingdom\"},{\"is_selected\":0,\"title\":\"Germany\"},{\"is_selected\":0,\"title\":\"France\"},{\"is_selected\":0,\"title\":\"Italy\"}]},{\"field_is_required\":1,\"field_type\":\"text\",\"title\":\"YOUR NAME\",\"field_required_star\":1,\"field_name\":\"your-name\",\"field_placeholder\":\"Your Name\",\"field_width\":{\"md\":\"50\",\"sm\":\"\",\"xs\":\"\"}},{\"field_is_required\":1,\"field_type\":\"text\",\"title\":\"YOUR EMAIL\",\"field_required_star\":1,\"field_name\":\"your-email\",\"field_placeholder\":\"Your Email\",\"field_width\":{\"md\":\"50\",\"sm\":\"\",\"xs\":\"\"}},{\"field_is_required\":1,\"field_type\":\"tel\",\"title\":\"PHONE\",\"field_required_star\":1,\"field_name\":\"phone\",\"field_width\":{\"md\":\"50\",\"sm\":\"\",\"xs\":\"\"},\"sp_form_builder_inner_item_select\":[{\"is_selected\":1,\"title\":\"Personal Goods\"},{\"is_selected\":0,\"title\":\"Business Goods\"}],\"field_placeholder\":\"Your Phone\"},{\"field_is_required\":1,\"field_type\":\"select\",\"title\":\"CHOOSE THE TYPE OF GOODS\",\"field_required_star\":1,\"field_name\":\"type-of-goods\",\"field_width\":{\"md\":\"50\",\"sm\":\"\",\"xs\":\"\"},\"sp_form_builder_inner_item_select\":[{\"is_selected\":1,\"title\":\"Personal Goods\"},{\"is_selected\":0,\"title\":\"Business Goods\"}]},{\"field_is_required\":0,\"field_type\":\"textarea\",\"is_resize\":0,\"title\":\"CARGO DESCRIPTION\",\"field_required_star\":0,\"field_name\":\"cargo-description\",\"field_placeholder\":\"Description ...\",\"field_width\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"}},{\"field_is_required\":0,\"field_type\":\"radio\",\"title\":\"EXTRA SERVICES\",\"field_required_star\":0,\"field_name\":\"extra-services\",\"field_width\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"},\"sp_form_builder_inner_item_radio\":[{\"is_radio_checked\":1,\"title\":\"Insurance\"},{\"is_radio_checked\":0,\"title\":\"Hazardous\"}]}],\"additional_header\":\"Reply-To: {{email}}\\nReply-name: {{first-name}} {{last-name}}\\nCc: {{email}}\",\"email_subject\":\"{{subject}} | {{email}} | {{site-name}}\",\"email_template\":\"<p><strong>From:</strong>{{first-name}} {{last-name}}</p>\\n<p><strong>Email:</strong>{{email}}</p>\\n<p><strong>Subject:</strong>{{subject}}</p>\\n<p><strong>Message:</strong>{{message}}</p>\",\"required_field_message\":\"Please fill the required field.\",\"success_message\":\"Email successfully sent!\",\"failed_message\":\"Email sent failed, fill required field and try again!\",\"enable_redirect\":0,\"enable_captcha\":0,\"captcha_type\":\"default\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"enable_policy\":0,\"policy_text\":\"I agree with the <a href=\\\"#\\\">Terms of Use</a> and <a href=\\\"#\\\">Privacy Policy</a> and I declare that I have read the information that is required in accordance with <a href=\\\"http://eur-lex.europa.eu/legal-content/EN/TXT/?uri=uriserv:OJ.L_.2016.119.01.0001.01.ENG&amp;toc=OJ:L:2016:119:TOC\\\" target=\\\"_blank\\\">Article 13 of GDPR.</a>\",\"btn_text\":\"GET A QUOTE\",\"btn_position\":\"sppb-text-left\",\"btn_icon_position\":\"left\",\"sp_form_style_option\":\"btn_style\",\"field_gutter\":{\"md\":15,\"sm\":15,\"xs\":15},\"field_horizontal_space\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"field_font_size\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"input_height\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"textarea_height\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"label_font_size\":{\"md\":\"12\",\"sm\":\"\",\"xs\":\"\"},\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_size\":\"\",\"btn_shape\":\"rounded\",\"btn_fontsize\":{\"md\":16},\"btn_letterspace\":\"0px\",\"button_status\":\"hover\",\"btn_background_color\":\"#4184d8\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#679ee2\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"btn_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"btn_padding\":{\"md\":\"12px 22px 12px 22px\",\"sm\":\"   \",\"xs\":\"   \"},\"btn_class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"btn_icon\":\"fas fa-arrow-alt-circle-right\",\"field_border_width\":\"   \",\"field_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"label_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"label_color\":\"#8c8c8c\"}}]}]}]},{\"id\":1615863542891,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/fatima-garcia-hzfifihonvy-unsplash.jpg\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1615864620910,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"30px 30px 10px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":1,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"background_color\":\"#f5f5f5\",\"row_border_width\":{\"md\":\"3px 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"row_border_color\":\"rgb(65, 132, 216)\"},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1615864620911,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615864620956,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Services\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Choose one of your service\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1615864620918,\"name\":\"navigation\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"sp_link_list_item\":[{\"title\":\"Air Freight\",\"active\":0,\"class\":\"sppb-btn-block mb-2\",\"url\":\"index.php/en/services/air-freight\",\"icon\":\"fas fa-plane\"},{\"title\":\"Ocean Freight\",\"active\":0,\"class\":\"sppb-btn-block mb-2\",\"url\":\"index.php/en/services/ocean-freight\",\"icon\":\"fas fa-ship\"},{\"title\":\"Road Freight\",\"active\":0,\"class\":\"sppb-btn-block mb-2\",\"url\":\"index.php/en/services/road-freight\",\"icon\":\"fas fa-truck-moving\"},{\"title\":\"Train Freight\",\"active\":0,\"class\":\"sppb-btn-block mb-2\",\"url\":\"index.php/en/services/train-freight\",\"icon\":\"fas fa-train\"}],\"scroll_to\":0,\"sticky_menu\":0,\"type\":\"list\",\"align\":\"left\",\"link_bg_hover\":\"#4084d8\",\"link_border_radius\":3,\"link_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"link_lineheight\":\"\",\"link_letterspace\":\"0\",\"link_text_transform\":\"none\",\"link_padding\":{\"md\":\"12px 20px 12px 20px\",\"sm\":\"7px 17px 7px 17px\",\"xs\":\"7px 17px 7px 17px\"},\"link_color_active\":\"#ffffff\",\"link_bg_active\":\"#4084D8\",\"link_border_radius_active\":3,\"icon_position\":\"left\",\"icon_size\":\"\",\"responsive_menu\":0,\"responsive_bar_bg\":\"rgba(0, 0, 0, .1)\",\"responsive_bar_bg_active\":\"#22b8f0\",\"responsive_bar_color\":\"#000\",\"responsive_bar_color_active\":\"#fff\",\"global_class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"link_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"link_bg\":\"#ffffff\",\"link_color\":\"#353535\",\"link_color_hover\":\"#ffffff\"}}]}]},{\"id\":1615871365202,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"30px 30px 50px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":1,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"background_color\":\"rgb(65, 132, 216)\",\"row_border_width\":{\"md\":\"3px 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"row_border_color\":\"rgb(37, 61, 107)\"},\"layout\":\"12,6,6\",\"visibility\":true,\"columns\":[{\"id\":1615871365203,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615871365204,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Documentations\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"global_text_color\":\"#ffffff\",\"title_text_color\":\"#ffffff\"}}]},{\"id\":1615879050556,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"default\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"items_align_center\":1,\"padding\":{\"md\":\"30px 0px 5px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0,\"background_type\":\"color\",\"background\":\"#ffffff\",\"items_content_alignment\":\"center\"},\"addons\":[{\"id\":1615879050566,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fas fa-file-pdf\",\"link\":\"images/Learning_materials.pdf\",\"size\":{\"md\":\"70\"},\"width\":{\"md\":\"80\"},\"height\":{\"md\":\"90\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"target\":\"_blank\"}},{\"id\":1615879050576,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Get Started\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1615879050557,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"default\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"items_align_center\":1,\"padding\":{\"md\":\"30px 0px 5px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0,\"background_type\":\"color\",\"background\":\"#ffffff\",\"items_content_alignment\":\"center\"},\"addons\":[{\"id\":1615879050608,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fas fa-file-pdf\",\"link\":\"images/Learning_materials.pdf\",\"size\":{\"md\":\"70\"},\"width\":{\"md\":\"80\"},\"height\":{\"md\":\"90\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"target\":\"_blank\"}},{\"id\":1615879050585,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"TAX Infor\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]}]},{\"id\":1615879050896,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"30px 30px 10px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":1,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"background_color\":\"#f5f5f5\",\"row_border_width\":{\"md\":\"3px 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"row_border_color\":\"rgb(65, 132, 216)\"},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1615879050897,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615879050898,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Tracking\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"To track shipments choose a KN Reference Type and enter your Tracking Number\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1615947105596,\"name\":\"form_builder\",\"visibility\":true,\"settings\":{\"admin_label\":\"Form Builder\",\"class\":\"\",\"form_elements\":\"felements\",\"sp_form_builder_item\":[{\"title\":\"REFERENCE TYPE\",\"field_name\":\"reference-type\",\"field_placeholder\":\"Reference Type\",\"field_type\":\"select\",\"field_width\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"},\"field_is_required\":1,\"field_required_star\":1,\"sp_form_builder_inner_item_select\":[{\"is_selected\":1,\"title\":\"Order ID\"},{\"is_selected\":0,\"title\":\"Transaction ID\"},{\"is_selected\":0,\"title\":\"Email\"}]},{\"title\":\"REFERENCE ID\",\"field_name\":\"reference-id\",\"field_placeholder\":\"Reference ID\",\"field_type\":\"text\",\"field_width\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"},\"field_is_required\":1,\"field_required_star\":1,\"sp_form_builder_inner_item_select\":[{\"is_selected\":1,\"title\":\"United Stade\"},{\"is_selected\":0,\"title\":\"United Kingdom\"},{\"is_selected\":0,\"title\":\"Germany\"},{\"is_selected\":0,\"title\":\"France\"},{\"is_selected\":0,\"title\":\"Italy\"}]}],\"additional_header\":\"Reply-To: {{email}}\\nReply-name: {{first-name}} {{last-name}}\\nCc: {{email}}\",\"email_subject\":\"{{subject}} | {{email}} | {{site-name}}\",\"email_template\":\"<p><strong>From:</strong>{{first-name}} {{last-name}}</p>\\n<p><strong>Email:</strong>{{email}}</p>\\n<p><strong>Subject:</strong>{{subject}}</p>\\n<p><strong>Message:</strong>{{message}}</p>\",\"required_field_message\":\"Please fill the required field.\",\"success_message\":\"Email successfully sent!\",\"failed_message\":\"Email sent failed, fill required field and try again!\",\"enable_redirect\":0,\"enable_captcha\":0,\"captcha_type\":\"default\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"enable_policy\":0,\"policy_text\":\"I agree with the <a href=\\\"#\\\">Terms of Use</a> and <a href=\\\"#\\\">Privacy Policy</a> and I declare that I have read the information that is required in accordance with <a href=\\\"http://eur-lex.europa.eu/legal-content/EN/TXT/?uri=uriserv:OJ.L_.2016.119.01.0001.01.ENG&amp;toc=OJ:L:2016:119:TOC\\\" target=\\\"_blank\\\">Article 13 of GDPR.</a>\",\"btn_text\":\"TRACK NOW\",\"btn_position\":\"sppb-text-left\",\"btn_icon_position\":\"left\",\"sp_form_style_option\":\"btn_style\",\"field_gutter\":{\"md\":15,\"sm\":15,\"xs\":15},\"field_horizontal_space\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"field_font_size\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"input_height\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"textarea_height\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"label_font_size\":{\"md\":\"12\",\"sm\":\"\",\"xs\":\"\"},\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_size\":\"\",\"btn_shape\":\"rounded\",\"btn_fontsize\":{\"md\":16},\"btn_letterspace\":\"0px\",\"button_status\":\"hover\",\"btn_background_color\":\"#4184d8\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#679ee2\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"btn_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"btn_padding\":{\"md\":\"12px 22px 12px 22px\",\"sm\":\"   \",\"xs\":\"   \"},\"btn_class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"btn_icon\":\"\",\"field_border_width\":\"   \",\"field_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"label_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"label_color\":\"#8c8c8c\"}}]}]}]}]}', '2021-03-17 03:46:50', '777');
/**ABDB**/CREATE TABLE `#__sppagebuilder_languages` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `lang_tag` varchar(255) NOT NULL DEFAULT '',
  `lang_key` varchar(100) DEFAULT NULL,
  `version` varchar(255) NOT NULL DEFAULT '',
  `state` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_integrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `component` varchar(255) NOT NULL DEFAULT '',
  `plugin` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_addons` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `code` mediumtext NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `text` mediumtext NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `published` tinyint(3) NOT NULL DEFAULT 1,
  `catid` int(10) NOT NULL DEFAULT 0,
  `access` int(10) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT 0,
  `checked_out` int(10) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL DEFAULT '',
  `og_image` varchar(255) NOT NULL DEFAULT '',
  `og_description` varchar(255) NOT NULL DEFAULT '',
  `language` char(7) NOT NULL DEFAULT '',
  `hits` bigint(20) NOT NULL DEFAULT 0,
  `css` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__sppagebuilder`  VALUES 
('1', '129', 'Home Version 2', '[{\"id\":1615624578323,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":1,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1615624578283,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1615624578284,\"name\":\"uislideshow\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title_addon\":\"\",\"title_heading_style\":\"h3\",\"title_heading_margin\":\"uk-margin\",\"title_heading_decoration\":\"\",\"title_heading_color\":\"\",\"title_heading_selector\":\"h3\",\"ui_slideshow_items\":[{\"image_panel\":0,\"media_blend_mode\":\"\",\"title\":\"Welcome to Transport JSC.<br/>Fast & Convenient\",\"content\":\"Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.\",\"title_link\":\"#\",\"text_item_color\":\"light\",\"media_item\":\"images/rqa-bg.jpg\",\"button_title\":\"Contact Us\"},{\"image_panel\":0,\"media_blend_mode\":\"\",\"title\":\"Transport your goods.<br/>Around the World\",\"content\":\"Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.\",\"title_link\":\"#\",\"text_item_color\":\"light\",\"media_item\":\"images/plant.jpg\",\"button_title\":\"Get In Touch\"},{\"image_panel\":0,\"media_blend_mode\":\"\",\"title\":\"With help from our fleet.<br/>Send it anywhere\",\"content\":\"Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.\",\"title_link\":\"#\",\"text_item_color\":\"light\",\"media_item\":\"images/ship.jpg\",\"button_title\":\"Find a Vendor\"}],\"height\":\"\",\"ratio\":\"\",\"min_height\":300,\"item_color\":\"light\",\"box_shadow\":\"\",\"slideshow_transition\":\"scale\",\"autoplay\":1,\"pause\":0,\"kenburns_transition\":\"top-left\",\"navigation\":\"dotnav\",\"navigation_below\":0,\"navigation_vertical\":0,\"navigation_below_position\":\"center\",\"navigation_position\":\"bottom-center\",\"navigation_below_margin\":\"top\",\"navigation_margin\":\"medium\",\"navigation_breakpoint\":\"s\",\"navigation_color\":\"\",\"thumbnav_wrap\":0,\"thumbnail_width\":100,\"thumbnail_height\":75,\"image_svg_inline\":0,\"image_svg_color\":\"\",\"slidenav_position\":\"default\",\"slidenav_on_hover\":0,\"larger_style\":0,\"slidenav_margin\":\"medium\",\"slidenav_breakpoint\":\"s\",\"slidenav_outside_breakpoint\":\"xl\",\"slidenav_outside_color\":\"\",\"overlay_container\":\"default\",\"overlay_container_padding\":\"small\",\"overlay_margin\":\"\",\"overlay_positions\":\"center-left\",\"overlay_styles\":\"\",\"overlay_background\":\"#ffd49b\",\"overlay_padding\":\"\",\"overlay_width\":\"\",\"overlay_transition\":\"\",\"heading_style\":\"heading-medium\",\"title_decoration\":\"\",\"title_color\":\"\",\"title_text_transform\":\"uppercase\",\"heading_selector\":\"h2\",\"title_margin_top\":\"\",\"use_title_parallax\":0,\"meta_style\":\"\",\"meta_color\":\"\",\"meta_text_transform\":\"\",\"meta_alignment\":\"\",\"meta_element\":\"div\",\"meta_margin_top\":\"\",\"use_meta_parallax\":0,\"content_style\":\"\",\"content_text_transform\":\"\",\"content_margin_top\":\"\",\"use_content_parallax\":0,\"all_button_title\":\"Read more\",\"link_button_style\":\"\",\"button_background\":\"#1e87f0\",\"button_background_hover\":\"#0f7ae5\",\"button_margin_top\":\"medium\",\"use_button_parallax\":0,\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"alignment\":\"\",\"text_breakpoint\":\"\",\"text_alignment_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"max_height\":\"800\",\"font_weight\":\"bolder\",\"kenburns_duration\":\"10\"}}]}]},{\"id\":1506348987038,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"separator1\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"separator2\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":0,\"no_gutter\":0,\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"50px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"\",\"background_image\":\"images/doted-map4.jpg\",\"background_parallax\":0,\"overlay\":\"\",\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_video\":\"0\",\"external_background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"background_external_video\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_align_center\":1,\"row_border\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"background_type\":\"image\"},\"layout\":\"8,4\",\"columns\":[{\"id\":1506348987039,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1615624578328,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Providing world leading freight services\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Morbi mattis est sit amet turpis iaculis egestas. Integer vitae libero eget lectus tincidunt dictum. In malesuada mi velit.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_text_color\":\"#ffffff\",\"global_text_color\":\"#ffffff\",\"title_font_style\":{\"uppercase\":true},\"title_margin_bottom\":{\"md\":\"5\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"}}}]},{\"id\":1506348987043,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":\"\",\"boxshadow\":\"\",\"class\":\"mt-20-lg \",\"sm_col\":\"\",\"xs_col\":\"\",\"separator\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1506348987046,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"get detailed quote\",\"alignment\":\"sppb-text-right\",\"fontstyle\":null,\"letterspace\":\"0\",\"url\":\"\",\"target\":\"\",\"type\":\"custom\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#ffffff\",\"background_color_hover\":\"#222222\",\"color_hover\":\"#ffffff\",\"button_padding\":{\"md\":\"15px 25px 15px 25px\",\"sm\":\"   \",\"xs\":\"   \"},\"size\":\"\",\"shape\":\"rounded\",\"block\":\"\",\"icon\":\"\",\"icon_position\":\"left\",\"class\":\"black\",\"global_options\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":{\"md\":\"0 0 30px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"\",\"global_use_animation\":0,\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null,\"icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"font_style\":{\"uppercase\":true},\"button_status\":\"hover\"}}]}]},{\"id\":1506350355403,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"separator1\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"separator2\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":0,\"no_gutter\":0,\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"90px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"background_parallax\":\"0\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"external_background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"background_external_video\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animation\":\"fadeInDown\",\"animationduration\":\"500\",\"animationdelay\":\"400\",\"columns_align_center\":0,\"row_border\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"layout\":\"12\",\"columns\":[{\"id\":1503546281524,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1615627730779,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"OUR SERVICES\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"40\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Phasellus porttitor leo a augue placerat, a consequat felis ullamcorper. Curabitur risus risus, tincidunt sollicitudin posuere blandit, tincidunt ut tellus. Duis ullamcorper at augue eu scelerisque.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_margin_bottom\":{\"md\":\"10\",\"sm\":\"\",\"xs\":\"\"}}},{\"id\":1504087548130,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"separator1\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"separator2\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"boder-lipbox\",\"padding\":\"10px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"background_parallax\":\"0\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"external_background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"background_external_video\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"4,4,4\",\"visibility\":true,\"columns\":[{\"id\":1504087548131,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":\"\",\"boxshadow\":\"\",\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"separator\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":\"500\",\"animationdelay\":\"300\"},\"addons\":[{\"id\":1615774194769,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"ROAD FREIGHT\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"20\"},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_width\":{\"md\":50},\"icon_name\":\"fas fa-truck\",\"icon_size\":{\"md\":36},\"icon_color\":\"#4184d8\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat.\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"30px 30px 26px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_border_color\":\"#dddddd\",\"global_boder_style\":\"solid\",\"title_margin_bottom\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin_bottom\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"addon_hover_bg\":\"#4184d8\",\"addon_hover_color\":\"#ffffff\",\"title_hover_color\":\"#ffffff\",\"icon_hover_color\":\"#ffffff\"}},{\"id\":1615774194836,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Packaging & Storage\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"20\"},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_width\":{\"md\":50},\"icon_name\":\"fas fa-ship\",\"icon_size\":{\"md\":36},\"icon_color\":\"#4184d8\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat.\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"30px 30px 26px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_border_color\":\"#dddddd\",\"global_boder_style\":\"solid\",\"title_margin_bottom\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin_bottom\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"title_font_style\":{\"uppercase\":true},\"addon_hover_bg\":\"#4184d8\",\"addon_hover_color\":\"#ffffff\",\"title_hover_color\":\"#ffffff\",\"icon_hover_color\":\"#ffffff\"}}]},{\"id\":1504087548134,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":\"\",\"boxshadow\":\"\",\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"separator\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"700\",\"animationdelay\":\"500\"},\"addons\":[{\"id\":1615774194798,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Ocean freight\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"20\"},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_width\":{\"md\":50},\"icon_name\":\"fas fa-cube\",\"icon_size\":{\"md\":36},\"icon_color\":\"#4184d8\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat.\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"30px 30px 26px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_border_color\":\"#dddddd\",\"global_boder_style\":\"solid\",\"title_margin_bottom\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin_bottom\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"title_font_style\":{\"uppercase\":true},\"addon_hover_bg\":\"#4184d8\",\"addon_hover_color\":\"#ffffff\",\"title_hover_color\":\"#ffffff\",\"icon_hover_color\":\"#ffffff\"}},{\"id\":1615774194853,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Warehousing\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"20\"},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_width\":{\"md\":50},\"icon_name\":\"fas fa-fighter-jet\",\"icon_size\":{\"md\":36},\"icon_color\":\"#4184d8\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat.\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"30px 30px 26px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_border_color\":\"#dddddd\",\"global_boder_style\":\"solid\",\"title_margin_bottom\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin_bottom\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"title_font_style\":{\"uppercase\":true},\"addon_hover_bg\":\"#4184d8\",\"addon_hover_color\":\"#ffffff\",\"title_hover_color\":\"#ffffff\",\"icon_hover_color\":\"#ffffff\"}}]},{\"id\":1504087548135,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":\"\",\"boxshadow\":\"\",\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"separator\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"fadeInRight\",\"animationduration\":\"500\",\"animationdelay\":\"400\"},\"addons\":[{\"id\":1615774194811,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Air freight\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"20\"},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_width\":{\"md\":50},\"icon_name\":\"fas fa-plane\",\"icon_size\":{\"md\":36},\"icon_color\":\"#4184d8\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat.\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"30px 30px 26px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_border_color\":\"#dddddd\",\"global_boder_style\":\"solid\",\"title_margin_bottom\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin_bottom\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"title_font_style\":{\"uppercase\":true},\"addon_hover_bg\":\"#4184d8\",\"addon_hover_color\":\"#ffffff\",\"title_hover_color\":\"#ffffff\",\"icon_hover_color\":\"#ffffff\"}},{\"id\":1615774194870,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Transporter\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"20\"},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_width\":{\"md\":50},\"icon_name\":\"fas fa-bus-alt\",\"icon_size\":{\"md\":36},\"icon_color\":\"#4184d8\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat.\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"30px 30px 26px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_border_color\":\"#dddddd\",\"global_boder_style\":\"solid\",\"title_margin_bottom\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin_bottom\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"title_font_style\":{\"uppercase\":true},\"addon_hover_bg\":\"#4184d8\",\"addon_hover_color\":\"#ffffff\",\"title_hover_color\":\"#ffffff\",\"icon_hover_color\":\"#ffffff\"}}]}]}]}]},{\"id\":1615774194926,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":1,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/rqa-bg.jpg\",\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"6,6\",\"columns\":[{\"id\":1615774194730,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"md\":\"10% 10% 10% 11%\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background\":\"rgba(245, 245, 245, 1)\"},\"addons\":[{\"id\":1615774194897,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"WHY CHOOSE US\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"40\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1504087548091,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"Fast Worldwide delivery\",\"title\":\"Fast Worldwide delivery\",\"heading_selector\":\"h4\",\"title_position\":\"left\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"separator_image_options\":\"\",\"separator_icon_options\":\"\",\"feature_image\":\"\",\"icon_name\":\"fa-check-circle\",\"icon_size\":\"\",\"icon_color\":\"#4184d8\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"separator_addon_options\":\"\",\"text\":\"Mauris quis suscipit metus. Donec lacinia scelerisque purus, vitae porta enim elementum sit amet. Ut magna tellus, laoreet eget rhoncus id, faucibus ut nibh. Vestibulum et scelerisque felis.\",\"alignment\":\"sppb-text-left\",\"class\":\"feature_x1\",\"global_options\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":{\"md\":\"0 0 30px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"\",\"global_use_animation\":0,\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null,\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}},{\"id\":1504087548097,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"Safety & Compliance\",\"title\":\"Safety & Compliance\",\"heading_selector\":\"h4\",\"title_position\":\"left\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"separator_image_options\":\"\",\"separator_icon_options\":\"\",\"feature_image\":\"\",\"icon_name\":\"fa-check-circle\",\"icon_size\":\"\",\"icon_color\":\"#4184d8\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"separator_addon_options\":\"\",\"text\":\"\\tMauris quis suscipit metus. Donec lacinia scelerisque purus, vitae porta enim elementum sit amet. Ut magna tellus, laoreet eget rhoncus id, faucibus ut nibh. Vestibulum et scelerisque felis.\",\"alignment\":\"sppb-text-left\",\"class\":\"feature_x1\",\"global_options\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":{\"md\":\"0 0 30px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"\",\"global_use_animation\":0,\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null,\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}},{\"id\":1504087548094,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"Fast Worldwide delivery\",\"title\":\"Fast Worldwide delivery\",\"heading_selector\":\"h4\",\"title_position\":\"left\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"separator_image_options\":\"\",\"separator_icon_options\":\"\",\"feature_image\":\"\",\"icon_name\":\"fa-check-circle\",\"icon_size\":\"\",\"icon_color\":\"#4184d8\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"separator_addon_options\":\"\",\"text\":\"Mauris quis suscipit metus. Donec lacinia scelerisque purus, vitae porta enim elementum sit amet. Ut magna tellus, laoreet eget rhoncus id, faucibus ut nibh. Vestibulum et scelerisque felis.\",\"alignment\":\"sppb-text-left\",\"class\":\"feature_x1\",\"global_options\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":{\"md\":\"0 0 30px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"\",\"global_use_animation\":0,\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null,\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}}]},{\"id\":1615774194732,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/ken-theimer-poe6q48b-5k-unsplash.jpg\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"overlay\":\"rgba(0, 37, 110, 0.9)\"},\"addons\":[{\"id\":1615774194731,\"name\":\"video_button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"video_url\":\"https://www.youtube.com/watch?v=V0PcwSLNi4M\",\"video_fontsize\":\"28\",\"use_border\":1,\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"#4184d8\",\"padding\":\"30px 28px 30px 32px\",\"background_color\":\"#ffffff\",\"border_radius\":\"100\",\"border_color\":\"rgba(253, 253, 253, 0.5)\",\"border_width\":\"3\"}}]}]},{\"id\":1506350355410,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"separator1\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"separator2\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"\",\"padding\":\"80px 0px 80px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"background_parallax\":\"0\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"external_background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"background_external_video\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"zoomIn\",\"animationduration\":\"500\",\"animationdelay\":\"300\"},\"layout\":\"12\",\"columns\":[{\"id\":1503885980245,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1615793610972,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"LATEST NEWS\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"40\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1615774194952,\"name\":\"uiarticles\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"meta_fontsize\":\"\",\"meta_lineheight\":\"\",\"meta_fontweight\":\"\",\"resource\":\"article\",\"post_type\":\"\",\"include_subcat\":1,\"ordering\":\"latest\",\"limit\":\"3\",\"columns\":\"3\",\"show_intro\":1,\"intro_limit\":\"90\",\"link_articles\":0,\"all_articles_btn_text\":\"See all posts\",\"all_articles_btn_letterspace\":\"0\",\"all_articles_btn_type\":\"default\",\"all_articles_btn_appearance\":\"flat\",\"all_articles_btn_background_color\":\"#444444\",\"all_articles_btn_color\":\"#fff\",\"all_articles_btn_background_color_hover\":\"#222\",\"all_articles_btn_color_hover\":\"#fff\",\"class\":\"\",\"hide_thumbnail\":0,\"thumbnail_height\":{\"md\":\"250\",\"sm\":\"\",\"xs\":\"\"},\"show_author\":1,\"show_category\":1,\"show_date\":1,\"show_readmore\":1,\"readmore_text\":\"Read More\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"catid\":[\"8\"],\"button_type\":\"link\",\"link_button_status\":\"hover\",\"button_text\":\"Read More\",\"button_font_family\":\"\",\"button_font_style\":{\"uppercase\":false},\"button_letterspace\":\"0\",\"link_button_color\":\"#666666\",\"link_button_hover_color\":\"#4184d8\",\"button_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_size\":\"\"}}]}]},{\"id\":1506350355448,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"separator1\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"separator2\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":0,\"no_gutter\":0,\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"120px 0px 90px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"\",\"background_image\":\"images/tz_logistics/pexels-chanaka-906494.jpg\",\"background_parallax\":0,\"overlay\":\"rgba(35, 42, 45, 0.9)\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"external_background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"background_external_video\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"columns_align_center\":0,\"row_border\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"background_type\":\"image\",\"overlay_type\":\"overlay_color\"},\"layout\":\"4,8,12\",\"columns\":[{\"id\":1503546281507,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":\"\",\"boxshadow\":\"\",\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"separator\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"600\",\"animationdelay\":\"500\"},\"addons\":[{\"id\":1615797767877,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"TESTIMONIALS\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"45\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Phasellus porttitor leo a augue.\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"15\",\"sm\":\"\",\"xs\":\"\"},\"text_lineheight\":{\"md\":\"32\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_font_style\":{\"weight\":700},\"title_text_color\":\"#ffffff\",\"global_text_color\":\"#ffffff\"}},{\"id\":1615862941221,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"View More\",\"alignment\":\"sppb-text-left\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"md\":16},\"button_status\":\"hover\",\"background_color\":\"rgb(65, 132, 216)\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#5e98e0\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"md\":\"10px 20px 12px 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"url\":\"./index.php/en/about-us/testimonials\"}}]},{\"id\":1615797767874,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{\"default\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"items_align_center\":0,\"animation\":\"fadeInRight\",\"animationduration\":\"600\",\"animationdelay\":\"400\"},\"addons\":[{\"id\":1615797767879,\"name\":\"uitestimonialslider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title_addon\":\"\",\"title_heading_style\":\"h3\",\"title_heading_margin\":\"uk-margin\",\"title_heading_decoration\":\"\",\"title_heading_color\":\"\",\"title_heading_selector\":\"h3\",\"ui_testimonialslider_item\":[{\"title\":\"Peter Holland\",\"company\":\"Director of Pet Shop\",\"client_review\":\"\",\"message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"link\":\"\",\"avatar\":\"images/avatars/05_team.png\"},{\"title\":\"Patrick Oliver\",\"company\":\"UI/UX Designer, London\",\"client_review\":\"\",\"message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"link\":\"\",\"avatar\":\"images/avatars/06_team.png\"},{\"title\":\"Leanne Simpson\",\"company\":\"Marketing Online\",\"client_review\":\"\",\"message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"link\":\"\",\"avatar\":\"images/avatars/04_testimonial.jpg\"},{\"title\":\"Mary Lane\",\"company\":\"C.E.O at TemPlaza.com\",\"client_review\":\"\",\"message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"link\":\"\",\"avatar\":\"images/avatars/03_testimonial.jpg\"}],\"ts_phone_portrait\":\"1-1\",\"ts_phone_landscape\":\"\",\"ts_tablet_landscape\":\"1-2\",\"ts_desktop\":\"\",\"ts_large_screens\":\"\",\"grid_column_gap\":\"\",\"divider\":0,\"header_alignment\":\"\",\"header_margin_top\":\"\",\"icon_color\":\"#fba311\",\"icon_rating\":\"\",\"rating_alignment\":\"\",\"card_styles\":\"default\",\"panel_link\":0,\"card_background\":\"#1e87f0\",\"card_size\":\"\",\"card_content_padding\":\"\",\"card_width\":\"\",\"slidesets\":0,\"center_slide\":0,\"finite_slide\":0,\"autoplay\":0,\"pause\":0,\"navigation\":\"\",\"navigation_position\":\"center\",\"navigation_margin\":\"uk-margin-top\",\"navigation_breakpoint\":\"s\",\"navigation_color\":\"\",\"slidenav_position\":\"top-right\",\"slidenav_margin\":\"medium\",\"slidenav_breakpoint\":\"s\",\"slidenav_color\":\"\",\"slidenav_outside_breakpoint\":\"xl\",\"slidenav_outside_color\":\"\",\"slidenav_on_hover\":0,\"larger_style\":0,\"image_position\":\"\",\"image_grid_width\":\"auto\",\"image_grid_column_gap\":\"small\",\"image_grid_breakpoint\":\"m\",\"vertical_alignment\":1,\"image_margin_top\":\"\",\"image_link\":0,\"avatar_width\":90,\"avatar_shape\":\"uk-border-circle\",\"image_svg_inline\":0,\"image_svg_color\":\"\",\"title_style\":\"\",\"title_text_color\":\"\",\"title_text_transform\":\"\",\"link_title\":0,\"title_hover_style\":\"reset\",\"heading_selector\":\"h3\",\"title_margin_top\":\"remove\",\"meta_style\":\"text-meta\",\"meta_text_transform\":\"\",\"meta_text_color\":\"\",\"meta_element\":\"div\",\"meta_margin_top\":\"remove\",\"content_style\":\"\",\"content_dropcap\":0,\"content_column\":\"\",\"content_column_divider\":0,\"content_column_breakpoint\":\"m\",\"content_text_transform\":\"\",\"content_margin_top\":\"\",\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"text_alignment\":\"\",\"text_breakpoint\":\"\",\"text_alignment_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1615797767917,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1615797767928,\"name\":\"uidivider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"uk-hr\",\"html_selector\":\"hr\",\"alignment\":\"\",\"alignment_breakpoint\":\"\",\"alignment_fallback\":\"\",\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"30px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"border_width\":\"1\",\"border_color\":\"rgba(221, 221, 221, 0.1)\"}},{\"id\":1615797767920,\"name\":\"clients\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"count\":\"sppb-col-sm-2\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"sp_clients_item\":[{\"title\":\"Client 1\",\"image\":\"images/xlogo-1.png\",\"url_same_window\":0},{\"title\":\"Client 1\",\"image\":\"images/xlogo-2.png\",\"url_same_window\":0},{\"title\":\"Client 1\",\"image\":\"images/xlogo-3.png\",\"url_same_window\":0},{\"title\":\"Client 1\",\"image\":\"images/xlogo-4.png\",\"url_same_window\":0},{\"title\":\"Client 1\",\"image\":\"images/xlogo-5.png\",\"url_same_window\":0},{\"title\":\"Client 1\",\"image\":\"images/xlogo-1.png\",\"url_same_window\":0}],\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1615797767923,\"name\":\"uidivider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"uk-hr\",\"html_selector\":\"hr\",\"alignment\":\"\",\"alignment_breakpoint\":\"\",\"alignment_fallback\":\"\",\"addon_margin\":\"\",\"addon_max_width\":\"\",\"addon_max_width_breakpoint\":\"\",\"block_align\":\"\",\"block_align_breakpoint\":\"\",\"block_align_fallback\":\"\",\"animation\":\"\",\"animation_repeat\":0,\"parallax_target\":0,\"parallax_zindex\":0,\"breakpoint\":\"\",\"visibility\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"border_width\":\"1\",\"border_color\":\"rgba(221, 221, 221, 0.1)\"}}]}]}]', 'com_sppagebuilder', 'page', '0', '0', '1', '0', '1', '0', '0000-00-00 00:00:00', '777', '2021-03-17 04:55:51', '777', '0', '0000-00-00 00:00:00', '[]', '', '', '', '*', '373', '');
