import '../css/style.scss';

const linguiseFrontendScript = (config = '') => {
    try {
        if (typeof config === "undefined" || config === null || config === '') {
            config = document.getElementsByClassName('linguise_switcher')[0].data('config');
        } else {
            config = JSON.parse(config);
        }
        if (typeof config === "undefined" || config === null || config === '') {
            return;
        }
    } catch (e) {

    }

    /**
     * Generate the url of the current page for another language
     */
    const getLanguageUrl = (language, config) => {
        // Try to find the alternate
        const alternate = document.querySelector('link[rel="alternate"][hreflang="' + language + '"]');
        if (alternate !== null && alternate.href !== undefined) {
            return alternate.href;
        }

        if (config.joomla_languages.indexOf(language) !== -1 && language !== config.language_default) {
            // This language is handled by Joomla
            return `${config.scheme}//${config.host + (config.base ? config.base : '') + '/' + language + config.trailing_slashes }`;
        }
        return `${config.scheme}//${config.host + (config.base ? config.base : '') + (language === config.language_default ? '' : '/' + language) + config.original_path + config.trailing_slashes + (config.query ? config.query : '')}`;
    }

    if (document.querySelector('.joomla_linguise_switcher') !== null) {
        switch (config.flag_display_type) {
            case 'popup':
                document.querySelector('.joomla_linguise_switcher').style.display = 'none';
                var ul_switcher = document.createElement("a");
                ul_switcher.classList.add('linguise_switcher');
                ul_switcher.classList.add('linguise_switcher_menu_popup');
                ul_switcher.classList.add('linguise_switcher_popup');
                if (config.flag_shape === 'rounded') {
                    ul_switcher.classList.add('linguise_flag_rounded');
                } else {
                    ul_switcher.classList.add('linguise_flag_rectangular');
                }

                ul_switcher.setAttribute("data-config", JSON.stringify(config));
                document.querySelector('.joomla_linguise_switcher').after(ul_switcher);
                document.querySelector('.linguise_switcher_menu_popup').onclick = function (e) {
                    e.preventDefault();
                    window.openLanguagePopUp();
                };
                break;

            case 'side_by_side':
                document.querySelector('.joomla_linguise_switcher').style.display = 'none';
                var ul_switcher = document.createElement("ul");
                ul_switcher.classList.add('linguise_switcher');
                ul_switcher.classList.add('linguise_switcher_side_by_side');
                if (config.flag_shape === 'rounded') {
                    ul_switcher.classList.add('linguise_flag_rounded');
                } else {
                    ul_switcher.classList.add('linguise_flag_rectangular');
                }

                ul_switcher.setAttribute("data-config", JSON.stringify(config));
                document.querySelector('.joomla_linguise_switcher').after(ul_switcher);
                break;

            case 'dropdown':
                document.querySelector('.joomla_linguise_switcher').style.display = 'none';
                var ul_switcher = document.createElement("ul");
                ul_switcher.classList.add('linguise_switcher');
                ul_switcher.classList.add('linguise_switcher_dropdown');
                if (config.flag_shape === 'rounded') {
                    ul_switcher.classList.add('linguise_flag_rounded');
                } else {
                    ul_switcher.classList.add('linguise_flag_rectangular');
                }

                ul_switcher.setAttribute("data-config", JSON.stringify(config));
                document.querySelector('.joomla_linguise_switcher').after(ul_switcher);
                break;
            default:
                document.querySelector('.joomla_linguise_switcher').setAttribute("data-config", JSON.stringify(config));
                document.querySelector('.joomla_linguise_switcher').classList.add('linguise_switcher_popup');
                if (config.flag_shape === 'rounded') {
                    document.querySelector('.joomla_linguise_switcher').classList.add('linguise_flag_rounded');
                } else {
                    document.querySelector('.joomla_linguise_switcher').classList.add('linguise_flag_rectangular');
                }
                break;
        }
    }

    var languages_keys = Object.keys(config.languages);
    config.scheme = window.location.protocol;
    config.host = window.location.host;
    config.query = window.location.search;

    if ((config.base ? config.base : '') + config.original_path.replace(/\/+$/g, '') !== window.location.pathname.replace(/\/+$/g, '')) {
        // Retrieve current language from url
        var regex = new RegExp('^' + (config.base !== '' ? config.base : '') + '/(' + languages_keys.join('|') + ')(?:/(.*)|$)');
        var result = regex.exec(window.location.pathname);

        if (result !== null && result.length >= 2 && result[1]) {
            config.current_language = result[1];
        } else {
            config.current_language = config.language_default;
        }
    } else {
        config.current_language = config.language_default;
    }

    var linguise_switcher = document.querySelectorAll('.linguise_switcher');
    if (linguise_switcher.length) {
        linguise_switcher.forEach(e => {
            var switcher = '';
            switch (config.flag_display_type) {
                case 'popup':
                    if (parseInt(config.enable_flag) === 1) {
                        switcher += `<span class="linguise_flags linguise_flag_${config.current_language} linguise_language_icon"></span>`;
                    }

                    if (parseInt(config.enable_language_name) === 1) {
                        switcher += `<span class="linguise_lang_name">${config.languages[config.current_language]}</span>`;
                    }

                    switcher += `<span class="lccaret">▼</span>`;
                    document.querySelectorAll('.linguise_switcher_popup').forEach(e => {
                        e.innerHTML = switcher;
                    });
                    break;

                case 'side_by_side':
                    for (var ij = 0; ij < languages_keys.length; ij++) {
                        switcher += `<li ${languages_keys[ij] === config.current_language ? 'class="linguise_current"' : ''}>`;

                        if (languages_keys[ij] !== config.current_language) {
                            switcher += '<a  href="' + getLanguageUrl(languages_keys[ij], config)+ '">';
                        }

                        if (parseInt(config.enable_flag) === 1) {
                            switcher += `<span class="linguise_flags linguise_flag_${languages_keys[ij]} linguise_language_icon"></span>`;
                        }

                        if (parseInt(config.enable_language_name) === 1) {
                            switcher += `<span class="linguise_lang_name">${config.languages[languages_keys[ij]]}</span>`;
                        }

                        if (languages_keys[ij] !== config.current_language) {
                            switcher += `</a>`;
                        }

                        switcher += `</li>`;
                    }

                    document.querySelectorAll('.linguise_switcher_side_by_side').forEach(e => {
                        e.innerHTML = switcher;
                    });
                    break;

                case 'dropdown':
                    switcher += `<li class="linguise_current">`;
                    if (parseInt(config.enable_flag) === 1) {
                        switcher += `<span class="linguise_flags linguise_flag_${config.current_language} linguise_language_icon"></span>`;
                    }

                    if (parseInt(config.enable_language_name) === 1) {
                        switcher += `<span class="linguise_lang_name">${config.languages[config.current_language]}</span>`;
                    }
                    switcher += `<span class="lccaret">▼</span>`;
                    switcher += `<ul class="linguise_switcher_sub ${languages_keys.length > 15 ? 'many_languages' : ''}">`;
                    for (var ij = 0; ij < languages_keys.length; ij++) {
                        if (languages_keys[ij] !== config.current_language) {
                            switcher += `<li>`;
                            if (languages_keys[ij] !== config.current_language) {
                                switcher += '<a  href="' + getLanguageUrl(languages_keys[ij], config)+ '">';
                            }
                            if (parseInt(config.enable_flag) === 1) {
                                switcher += `<span class="linguise_flags linguise_flag_${languages_keys[ij]} linguise_language_icon"></span>`;
                            }

                            if (parseInt(config.enable_language_name) === 1) {
                                switcher += `<span class="linguise_lang_name">${config.languages[languages_keys[ij]]}</span>`;
                            }
                            if (languages_keys[ij] !== config.current_language) {
                                switcher += `</a>`;
                            }
                            switcher += `</li>`;
                        }
                    }

                    switcher += '</ul>';
                    switcher += `</li>`;
                    document.querySelectorAll('.linguise_switcher_dropdown').forEach(e => {
                        e.innerHTML = switcher;
                    });
                    break;

                default:
                    if (parseInt(config.enable_flag) === 1) {
                        switcher += `<span class="linguise_flags linguise_flag_${config.current_language} linguise_language_icon"></span>`;
                    }

                    if (parseInt(config.enable_language_name) === 1) {
                        switcher += `<span class="linguise_lang_name">${config.languages[config.current_language]}</span>`;
                    }

                    switcher += `<span class="lccaret">▼</span>`;
                    document.querySelectorAll('.linguise_switcher_popup').forEach(e => {
                        e.innerHTML = switcher;
                    });
            }

            if (config.display_position === 'top_left_no_scroll' || config.display_position === 'top_right_no_scroll' || config.display_position === 'bottom_left_no_scroll' || config.display_position === 'bottom_right_no_scroll') {
                document.querySelector('body').appendChild(e);
            }
        })
    }

    window.openLanguagePopUp = function (e) {
        if (e !== undefined && e.prevenDefault) {
            e.preventDefault();
        }

        if (window.language_popup_initialised === true) {
            document.querySelector('#linguise_background').style.display = 'block';
            document.querySelector('#linguise_popup').style.display = 'block';
            return;
        }

        window.language_popup_initialised = true;
        var script = `<div id="linguise_background"></div><div id="linguise_popup" class="${((config['flag_shape'] === 'rounded') ? 'linguise_flag_rounded' : 'linguise_flag_rectangular')}"><a class="close" href="#"><span></span></a>`;

        if (config.pre_text) {
            script += `<p>${config.pre_text}</p>`;
        }

        script += `<ul translate="no">`;

        for (var ij = 0; ij < languages_keys.length; ij++) {
            script += `<li ${languages_keys[ij] === config.current_language ? 'class="linguise_current"' : ''}>`;

            if (languages_keys[ij] !== config.current_language) {
                script += '<a  href="' + getLanguageUrl(languages_keys[ij], config)+ '">';
            }

            script += `<span class="linguise_flags linguise_flag_${languages_keys[ij]}"></span>`;
            script += `<span class="linguise_lang_name">${config.languages[languages_keys[ij]]}</span>`;

            if (languages_keys[ij] !== config.current_language) {
                script += `</a>`;
            }

            script += `</li>`;
        }

        script += `</ul>`;

        if (config.post_text) {
            script += `<p>${config.post_text}</p>`;
        }

        script += `</div>`;
        document.querySelector('body').innerHTML += script;
        document.querySelector('#linguise_background').onclick = function (e) {
            e.preventDefault();
            document.querySelector('#linguise_background').style.display = 'none';
            document.querySelector('#linguise_popup').style.display = 'none';
        };

        document.querySelector('#linguise_popup .close').onclick = function (e) {
            e.preventDefault();
            document.querySelector('#linguise_background').style.display = 'none';
            document.querySelector('#linguise_popup').style.display = 'none';
        };

        if (document.querySelector('.linguise_switcher_menu_popup') !== null) {
            document.querySelector('.linguise_switcher_menu_popup').onclick = function (e) {
                e.preventDefault();
                window.openLanguagePopUp();
            };
        }
    };
};


const loadConfigMenu = () => {
    let config = '';
    try {
        config = document.querySelectorAll('[type="linguise/json"]')[0].innerHTML;
        if (typeof config === "undefined") {
            config = '';
        }
    } catch (e) {}

    linguiseFrontendScript(config);

}
if (document.readyState !== 'loading') {
    loadConfigMenu();
} else {
    document.addEventListener('DOMContentLoaded', function () {
        loadConfigMenu();
    });
}