<?php
/**
 * Linguise
 *
 * We developed this code with our hearts and passion.
 * We hope you found it useful, easy to understand and to customize.
 * Otherwise, please feel free to contact us at contact@linguise.com
 *
 * @package   Linguise
 * @copyright Copyright (C) 2021 Linguise (http://www.linguise.com). All rights reserved.
 * @license   GNU General Public License version 2 or later; http://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') or die('Restricted access');
$mode_style = '';
if ($options['display_position'] !== 'no') {
    if ($options['flag_display_type'] === 'popup') {
        $mode_style .= '.linguise_switcher_popup{padding: 5px 10px}';
    }

    if ($options['flag_display_type'] === 'dropdown') {
        $mode_style .= '.linguise_switcher_dropdown ul{border-radius: 0}';
        $mode_style .= '.linguise_switcher_dropdown ul li{padding: 5px 10px; border-bottom: #eee 1px solid;}';
    }

    if ($options['display_position'] === 'top_left' || $options['display_position'] === 'top_left_no_scroll') {
        $mode_style .= '.linguise_switcher.linguise_switcher_not_menu{position: fixed; top: 20px; left: 20px;z-index: 99999; background: #fff; border-radius: 0;}';
        $mode_style .= '.linguise_switcher.linguise_switcher_not_menu li.linguise_current ul{left: 0; right: auto}';
    }

    if ($options['display_position'] === 'top_right' || $options['display_position'] === 'top_right_no_scroll') {
        $mode_style .= '.linguise_switcher.linguise_switcher_not_menu{position: fixed; top: 20px; right: 20px;z-index: 99999; background: #fff; border-radius: 0;}';
        $mode_style .= '.linguise_switcher.linguise_switcher_not_menu li.linguise_current ul{right: 0; left: auto}';
    }

    if ($options['display_position'] === 'bottom_left' || $options['display_position'] === 'bottom_left_no_scroll') {
        $mode_style .= '.linguise_switcher.linguise_switcher_not_menu{position: fixed; bottom: 20px; left: 20px;z-index: 99999; background: #fff; border-radius: 0;}';
        $mode_style .= '.linguise_switcher.linguise_switcher_not_menu li.linguise_current ul{left: 0; right: auto; bottom: 100%; top: auto}';
        $mode_style .= '.linguise_switcher_dropdown.linguise_switcher_not_menu ul{box-shadow: none; border: #eee 1px solid}';
        $mode_style .= '.linguise_switcher_dropdown.linguise_switcher_not_menu .lccaret{transform: rotate(180deg);}';
    }

    if ($options['display_position'] === 'bottom_right' || $options['display_position'] === 'bottom_right_no_scroll') {
        $mode_style .= '.linguise_switcher.linguise_switcher_not_menu{position: fixed; bottom: 20px; right: 20px;z-index: 99999; background: #fff; border-radius: 0;}';
        $mode_style .= '.linguise_switcher.linguise_switcher_not_menu li.linguise_current ul{right: 0; left: auto; bottom: 100%; top: auto}';
        $mode_style .= '.linguise_switcher_dropdown.linguise_switcher_not_menu ul{box-shadow: none; border: #eee 1px solid}';
        $mode_style .= '.linguise_switcher_dropdown.linguise_switcher_not_menu .lccaret{transform: rotate(180deg);}';
    }

    $mode_style .= '.linguise_switcher_dropdown.linguise_switcher_not_menu li.linguise_current{border: #eee 1px solid; padding: 5px 10px}';
    if (in_array($options['display_position'], array('top_left_no_scroll', 'top_right_no_scroll', 'bottom_left_no_scroll', 'bottom_right_no_scroll'))) {
        $mode_style .= '.linguise_switcher.linguise_switcher_not_menu{position: absolute}';
    }
}

$mode_style = LinguiseHelper::linguiseRenderCustomCss($options, $mode_style);
$current_language = JFactory::getApplication()->input->getCmd('language', LinguiseHelper::getOption('language_default', 'en'));
$language_list = LinguiseHelper::getOption('languages', []);
switch ($options['flag_display_type']) {
    case 'popup':
        $display = '<span class="linguise_flags linguise_flag_' . htmlspecialchars($current_language) . ' linguise_language_icon"></span>';
        $display .= '<span class="linguise_lang_name">'. htmlspecialchars($language_list[$current_language]) .'</span>';
        $content = '<a 
            class="linguise_switcher linguise_switcher_not_menu linguise_switcher_popup '. ($options['flag_shape'] === 'rounded' ? 'linguise_flag_rounded' : 'linguise_flag_rectangular') .'"
            href="javascript:openLanguagePopUp();">' . $display . '
          </a>';
        break;
    case 'side_by_side':
        $content = '<ul class="linguise_switcher linguise_switcher_not_menu linguise_switcher_side_by_side '. ($options['flag_shape'] === 'rounded' ? 'linguise_flag_rounded' : 'linguise_flag_rectangular') .'">';
        $content .= '<li>';
        if ((int)$options['enable_flag'] === 1) {
            $content .= '<span class="linguise_flags linguise_flag_' . htmlspecialchars($current_language) . ' linguise_language_icon"></span>';
        }

        if ((int)$options['enable_language_name'] === 1) {
            $content .= '<span class="linguise_lang_name">'. htmlspecialchars($language_list[$current_language]) .'</span>';
        }
        $content .= '</li>';
        $content .= '</ul>';
        break;
    case 'dropdown':
        $content = '<ul class="linguise_switcher linguise_switcher_not_menu linguise_switcher_dropdown '. ($options['flag_shape'] === 'rounded' ? 'linguise_flag_rounded' : 'linguise_flag_rectangular') .'">';

        $content .= '</ul>';
        break;
    default:
        $display = '<span class="linguise_flags linguise_flag_' . htmlspecialchars($current_language) . ' linguise_language_icon"></span>';
        $display .= '<span class="linguise_lang_name">'. htmlspecialchars($language_list[$current_language]) .'</span>';
        $content = '<a 
            class="linguise_switcher linguise_switcher_not_menu linguise_switcher_popup"
            href="javascript:openLanguagePopUp();">' . $display . '
          </a>';
}
$jversion = new JVersion();
if (version_compare($jversion->getShortVersion(), '4.0', 'gt')) {
    echo $content;
}
?>
<style type="text/css">
    <?php echo $mode_style ?>
</style>
