<?php
/**
 * @package   Jollyany Framework
 * @author    TemPlaza https://www.templaza.com
 * @copyright Copyright (C) 2009 - 2021 TemPlaza.
 * @license https://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */
defined('_JEXEC') or die;

class JollyanyFrameworkDataImport {
	protected static $api  =   'https://www.templaza.com';
	public static $cache   =    array('thumb' => array());
	protected static $exts =    array(
	    'sp-page-builder'  =>   array(
            'name'      =>  'SP Page Builder',
            'type'      =>  'included',
            'code'      =>  'tz_extensions',
            'ext_code'  =>  'sp-page-builder',
        ),
        'tz-portfolio'  =>      array(
            'name'      =>  'TZ Portfolio',
            'type'      =>  'url',
            'url'       =>  'https://github.com/templaza/tz_portfolio_plus/archive/master.zip',
            'ext_code'  =>  'tz-portfolio',
        ),
        'hikashop'      =>      array(
            'name'      =>  'Hikashop',
            'type'      =>  'url',
            'url'       =>  'https://www.hikashop.com/component/updateme/downloadxml/component-hikashop/level-starter/download.zip',
            'ext_code'  =>  'hikashop',
        )
    );
    protected static $exts_convert       =   [
        'sp-page-builder' => 'com_sppagebuilder',
        'tz-portfolio' => 'com_tz_portfolio_plus',
        'hikashop' => 'com_hikashop',
    ];
	protected static $data =    null;
    protected static $replacer   =   [
        'tz_fashion_semona_joomla'  => 'tz_fashion',
        'tz_everline_joomla'        => 'tz_everline',
        'tz_eventory_joomla'        => 'tz_eventory',
        'tz_charity_joomla'         => 'tz_charity',
        'tz_foodz_joomla'           => 'tz_foodz',
        'profiler-joomla-template'  => 'tz_profiler',
    ];

	public static function getThumb($src) {
        if (file_exists(JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'jollyany'.$src)) {
            return JUri::base(true).'/cache/jollyany'.$src;
        } else {
            self::$cache['thumb'][] =   $src;
            return self::$api.$src;
        }
    }

    public static function getTotalTemplate() {
        return count(self::getData());
    }

	public static function getApiUrl() {
		return self::$api;
	}

	public static function getExtensions() {
	    return self::$exts;
    }

    public static function getExtCode($key) {
	    if (isset(self::$exts_convert[$key])) {
            return self::$exts_convert[$key];
        }
        return false;
    }

    public static function getConvertCode($key) {
        if (isset(self::$replacer[$key])) {
            return self::$replacer[$key];
        }
        return $key;
    }

	public static function getData() {
	    self::$data   =   array(
            'tz_newspaper'      =>  array(
                // Pack Info
                'name'        => 'Newspaper',
                'desc'        => 'Magazine, Blog Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/newspaper/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://newspaper.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/newspaper',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Newspaper Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_newspaper',
                    'ext_code'  =>  'tz-newspaper-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder']
                ),
            ),
            'tz_magazine'      =>  array(
                // Pack Info
                'name'        => 'Magazine',
                'desc'        => 'Blog, Newspaper Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/magazine/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://magazine.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/magazine',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Magazine Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_magazine',
                    'ext_code'  =>  'tz-magazine-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder']
                ),
            ),
            'tz_varaham'      =>  array(
                // Pack Info
                'name'        => 'Varaham',
                'desc'        => 'Education University Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/varaham/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://varaham.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/varaham',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Varaham Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_varaham',
                    'ext_code'  =>  'tz-varaham-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder']
                ),
            ),
            'tz_krypton'      =>  array(
                // Pack Info
                'name'        => 'Krypton',
                'desc'        => 'Bitcoin Crypto Currency Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/krypton/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://krypton.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/krypton',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Krypton Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_krypton',
                    'ext_code'  =>  'tz-krypton-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder']
                ),
            ),
            'tz_alita'      =>  array(
                // Pack Info
                'name'        => 'Alita',
                'desc'        => 'Web Studio & Creative Agency Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/alita/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://alita.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/alita',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Alita Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_alita',
                    'ext_code'  =>  'tz-alita-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_martha'      =>  array(
                // Pack Info
                'name'        => 'Martha',
                'desc'        => 'Creative Portfolio Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/martha/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://martha.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/martha',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Martha Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_martha',
                    'ext_code'  =>  'tz-martha-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_logistics'      =>  array(
                // Pack Info
                'name'        => 'Logistics',
                'desc'        => 'Cargo Transportation Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/logistics/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://logistics.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/logistics',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Logistics Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_logistics',
                    'ext_code'  =>  'tz-logistics-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                ),
            ),
            'tz_pethub'      =>  array(
                // Pack Info
                'name'        => 'PetHub',
                'desc'        => 'Dog, Cat Care & Veterinary Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/pethub/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://pethub.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/pethub',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'PetHub Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_pethub',
                    'ext_code'  =>  'tz-pethub-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_goldena'      =>  array(
                // Pack Info
                'name'        => 'GoldenA',
                'desc'        => 'Single Property Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/goldena/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://goldena.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/goldena',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'GoldenA Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_goldena',
                    'ext_code'  =>  'tz-goldena-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                ),
            ),
            'tz_educab'      =>  array(
                // Pack Info
                'name'        => 'Educab',
                'desc'        => 'University Education Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/educab/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://educab.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/educab',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Educab Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_educab',
                    'ext_code'  =>  'tz-educab-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                ),
            ),
            'profiler-joomla-template'      =>  array(
                // Pack Info
                'name'        => 'Profiler',
                'desc'        => 'Personal Blog Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/profiler/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://profiler.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/profiler',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Profiler Template',
                    'type'      =>  'included',
                    'code'      =>  'profiler-joomla-template',
                    'ext_code'  =>  'tz-profiler-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                ),
            ),
            'tz_musika'      =>  array(
                // Pack Info
                'name'        => 'Musika',
                'desc'        => 'Music Band Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/musika/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://musika.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/musika',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Musika Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_musika',
                    'ext_code'  =>  'tz-musika-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_jollyany'   =>  array(
                // Pack Info
                'name'        => 'Jollyany Classic',
                'desc'        => 'Multi-purpose, Business & Corporation',

                // Pack Data
                'thumb'       => '/images/stories/jollyany/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation',

                'joomla_version'     => array(3,4),

                'template'    => array(
                    'name'      =>  'Jollyany Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_jollyany',
                    'ext_code'  =>  'tz-jollyany-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                ),
            ),
            'tz_everline_joomla'      =>  array(
                // Pack Info
                'name'        => 'Everline',
                'desc'        => 'Wedding Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/everline/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://everline.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/everline',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Everline Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_everline_joomla',
                    'ext_code'  =>  'tz-everline-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_eventory_joomla'      =>  array(
                // Pack Info
                'name'        => 'Eventory',
                'desc'        => 'Festival, Event Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/eventory/eventory_590.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://eventory.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/eventory',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Eventory Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_eventory_joomla',
                    'ext_code'  =>  'tz-eventory-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_meetup'      =>  array(
                // Pack Info
                'name'        => 'Meetup',
                'desc'        => 'Conference Event Joomla Template',

                // Pack Data
                'thumb'       => '/images/stories/meetup/meetup.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://meetup.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/meetup',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Meetup Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_meetup',
                    'ext_code'  =>  'tz-meetup-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_new_age'      =>  array(
                // Pack Info
                'name'        => 'New Age',
                'desc'        => 'Creative Agency, Business, Company',

                // Pack Data
                'thumb'       => '/images/stories/new_age/new_age_590.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://newage.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/new-age',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'New Age Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_new_age',
                    'ext_code'  =>  'tz-new-age-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_nish_ii'   =>  array(
                // Pack Info
                'name'        => 'Nish II',
                'desc'        => 'Portfolio, Agency & Photography',

                // Pack Data
                'thumb'       => '/images/stories/nish_ii/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://nish2.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/nish_ii',

                'joomla_version'     => array(3,4),

                'template'    => array(
                    'name'      =>  'Nish II Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_nish_ii',
                    'ext_code'  =>  'tz-nish-ii-api',
                ),

                'extensions'  => array(
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_fashion_semona_joomla'      =>  array(
                // Pack Info
                'name'        => 'Fashion',
                'desc'        => 'Model Agency, Photography',

                // Pack Data
                'thumb'       => '/images/stories/fashion/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://fashion.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/fashion',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Fashion Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_fashion_semona_joomla',
                    'ext_code'  =>  'tz-fashion-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_lawyer'    =>  array(
                // Pack Info
                'name'        => 'Lawyer Justice',
                'desc'        => 'Lawyers Attorneys and Law Firm',

                // Pack Data
                'thumb'       => '/images/stories/lawyer_justice/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://justice.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/lawyer-justice',

                'joomla_version'     => array(3,4),

                'template'    => array(
                    'name'      =>  'Lawyer Justice Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_lawyer',
                    'ext_code'  =>  'tz-lawyer-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_charity_joomla'    =>  array(
                // Pack Info
                'name'        => 'Charity',
                'desc'        => 'Non-profit, NGO & Fundraising',

                // Pack Data
                'thumb'       => '/images/stories/charity/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://charity.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/charity',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Charity Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_charity_joomla',
                    'ext_code'  =>  'tz-charity-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_foodz_joomla'      =>  array(
                // Pack Info
                'name'        => 'Foodz',
                'desc'        => 'Restaurant, Receipt & Bakery',

                // Pack Data
                'thumb'       => '/images/stories/foodz/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://foodz.jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation/extra-templates/foodz',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Foodz Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_foodz_joomla',
                    'ext_code'  =>  'tz-foodz-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
            'tz_construction'      =>  array(
                // Pack Info
                'name'        => 'Construction',
                'desc'        => 'Building, Construction & Architect',

                // Pack Data
                'thumb'       => '/images/stories/construction/thumbnail.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://construction.jollyany.co/',
                'doc_url'     => 'https://www.templaza.com/docs/construction/',

                'joomla_version'     => array(3,4),

                'template'      => array(
                    'name'      =>  'Construction Template',
                    'type'      =>  'included',
                    'code'      =>  'tz_construction',
                    'ext_code'  =>  'tz-construction-api',
                ),

                'extensions'  => array(
                    self::$exts['sp-page-builder'],
                    self::$exts['tz-portfolio'],
                    self::$exts['hikashop'],
                ),
            ),
        );
	    foreach (self::$data as $key => &$temp) {
	        $temp['thumb'] = self::getThumb($temp['thumb']);
        }
		return self::$data;
	}
}
