/*
 * @package   akeebabackup
 * @copyright Copyright (c)2006-2021 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

-- Ensure the correct character set and collation for all tables and columns
ALTER TABLE `#__akeebabackup_profiles`
    DEFAULT CHARSET utf8mb4
        DEFAULT COLLATE utf8mb4_unicode_ci,
    CHANGE `description` `description` varchar(255) NOT NULL COLLATE utf8mb4_unicode_ci,
    CHANGE `configuration` `configuration` longtext COLLATE utf8mb4_unicode_ci,
    CHANGE `filters` `filters` longtext COLLATE utf8mb4_unicode_ci;

ALTER TABLE `#__akeebabackup_backups`
    DEFAULT CHARSET utf8mb4
        DEFAULT COLLATE utf8mb4_unicode_ci,
    CHANGE `description` `description` varchar(255) NOT NULL COLLATE utf8mb4_unicode_ci,
    CHANGE `comment` `comment` longtext COLLATE utf8mb4_unicode_ci,
    CHANGE `origin` `origin` varchar(30) NOT NULL DEFAULT 'backend' COLLATE utf8mb4_unicode_ci,
    CHANGE `type` `type` varchar(30) NOT NULL DEFAULT 'full' COLLATE utf8mb4_unicode_ci,
    CHANGE `archivename` `archivename` longtext COLLATE utf8mb4_unicode_ci,
    CHANGE `absolute_path` `absolute_path` longtext COLLATE utf8mb4_unicode_ci,
    CHANGE `tag` `tag` varchar(255) DEFAULT NULL COLLATE utf8mb4_unicode_ci,
    CHANGE `backupid` `backupid` varchar(255) DEFAULT NULL COLLATE utf8mb4_unicode_ci,
    CHANGE `remote_filename` `remote_filename` varchar(1000) DEFAULT NULL COLLATE utf8mb4_unicode_ci;

ALTER TABLE `#__akeebabackup_storage`
    DEFAULT CHARSET utf8mb4
        DEFAULT COLLATE utf8mb4_unicode_ci,
    CHANGE `tag` `tag` varchar(255) NOT NULL COLLATE utf8mb4_unicode_ci,
    CHANGE `lastupdate` `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COLLATE utf8mb4_unicode_ci,
    CHANGE `data` `data` longtext COLLATE utf8mb4_unicode_ci;

ALTER TABLE `#__akeeba_common`
    DEFAULT CHARSET utf8mb4
        DEFAULT COLLATE utf8mb4_unicode_ci,
    CHANGE `key` `key` VARCHAR(190) NOT NULL COLLATE utf8mb4_unicode_ci,
    CHANGE `value` `value` LONGTEXT NOT NULL COLLATE utf8mb4_unicode_ci;
