<?php
/**
 * Linguise
 *
 * We developed this code with our hearts and passion.
 * We hope you found it useful, easy to understand and to customize.
 * Otherwise, please feel free to linguise us at linguise@linguise.com
 *
 * @package   Linguise
 * @copyright Copyright (C) 2021 Linguise (http://www.linguise.com). All rights reserved.
 * @license   GNU General Public License version 2 or later; http://www.gnu.org/licenses/gpl-2.0.html
 */


defined('_JEXEC') or die;
JHtml::_('jquery.framework');

$doc = JFactory::getDocument();
$doc->addScript('https://code.jquery.com/ui/1.12.1/jquery-ui.js');
$doc->addScript(JURI::root() . 'administrator/components/com_linguise/assets/minicolors/jquery.minicolors.min.js');
$doc->addStyleSheet(JURI::root() . '/administrator/components/com_linguise/assets/minicolors/jquery.minicolors.css');
$doc->addScript(JUri::root() . 'administrator/components/com_linguise/assets/js/jquery-chosen-sortable.min.js');
$doc->addScript(JUri::root() . 'administrator/components/com_linguise/assets/js/admin.bundle.js');
$doc->addStyleSheet(JUri::root() . 'administrator/components/com_linguise/assets/css/admin.bundle.css');
$doc->addStyleSheet(JUri::root() . 'modules/mod_linguise/assets/css/front.bundle.css');

$linguiseTabs = array(
    'main_settings' => array(
        'menu_name' => 'Main settings',
        'content' => 'main-settings',
        'icon' => 'translate'
    ),
    'advanced' => array(
        'menu_name' => 'Advanced',
        'content' => 'advanced',
        'icon' => 'code'
    )
);

$errors = [];
$uri = JUri::getInstance(true);
$change_token = false;
$jversion = new JVersion();
if (isset($_POST['linguise_options'])) {
    $old_options = LinguiseHelper::getOptions();
    $linguise_options = $_POST['linguise_options'];
    $language_default = LinguiseHelper::sanitize_key($linguise_options['language_default']);
    // Change token
    $token = $linguise_options['linguise_field_token'];
    if ($token && $token !== $old_options['linguise_field_token']) {
        $change_token = true;
        $languages_enabled = array();
        try {
            $url = JURI::root();
            $result = \JHttpFactory::getHttp()->get('https://api.linguise.com/api/config', array('Referer' => $url, 'authorization' => $token));
        } catch (\RuntimeException $exception) {
            $result = false;
        }

        if (version_compare($jversion->getShortVersion(), '4.0', 'gt')) {
            if (!empty($result)) {
                $responses = json_decode($result->__get('body'));
                if (isset($responses->status_code) && ($responses->status_code === 200)) {
                    if (!empty($responses) && is_object($responses)) {
                        $language_default = LinguiseHelper::sanitize_key($responses->data->language);
                        $translation_languages = $responses->data->languages;
                        if (!empty($translation_languages)) {
                            $languages_enabled = array();
                            foreach ($translation_languages as $translation_language) {
                                $languages_enabled[] = LinguiseHelper::sanitize_key($translation_language->code);
                            }
                        }
                    }
                } elseif (!empty($result) && isset($responses->status_code) && ($responses->status_code === 404)) {
                    $errors[] = [
                        'type' => 'error',
                        'message' => 'The API Key provided has been rejected, please make sure you use the right key associated with the domain ' . $url,
                    ];
                } else {
                    $errors[] = [
                        'type' => 'error',
                        'message' => 'Configuration has not been loaded from Linguise website. Please try again later or contact our support team if the problem persist.',
                    ];
                }
            } else {
                $errors[] = [
                    'type' => 'error',
                    'message' => 'Configuration has not been loaded from Linguise website. Please try again later or contact our support team if the problem persist.',
                ];
            }
        } else {
            if (!empty($result) && isset($result->code)
                && ($result->code === 200) && !empty($result->body)) {
                $apiResponse = json_decode($result->body);
                if (!empty($apiResponse) && is_object($apiResponse)) {
                    $language_default = LinguiseHelper::sanitize_key($apiResponse->data->language);
                    $translation_languages = $apiResponse->data->languages;
                    if (!empty($translation_languages)) {
                        $languages_enabled = array();
                        foreach ($translation_languages as $translation_language) {
                            $languages_enabled[] = LinguiseHelper::sanitize_key($translation_language->code);
                        }
                    }
                }
            } elseif (!empty($result) && isset($result->code)
                && ($result->code === 404)) {
                $errors[] = [
                    'type' => 'error',
                    'message' => 'The API Key provided has been rejected, please make sure you use the right key associated with the domain ' . $url,
                ];
            } else {
                $errors[] = [
                    'type' => 'error',
                    'message' => 'Configuration has not been loaded from Linguise website. Please try again later or contact our support team if the problem persist.',
                ];
            }
        }
    }

    if ($change_token) {
        $translate_languages = $languages_enabled;
    } else {
        $translate_languages = [];
        if (!empty($_POST['languages_enabled_sortable'])) {
            $lang_lists = explode(',', $_POST['languages_enabled_sortable']);
        } else {
            $lang_lists = (!empty($linguise_options['languages_enabled'])) ? $linguise_options['languages_enabled'] : array();
        }

        if (!empty($lang_lists)) {
            foreach ($lang_lists as $language) {
                if (isset($languages_enabled) && is_array($languages_enabled)) {
                    if (in_array($language, $languages_enabled)) {
                        $translate_languages[] = LinguiseHelper::sanitize_key($language);
                    }
                } else {
                    $translate_languages[] = LinguiseHelper::sanitize_key($language);
                }
            }
        }
    }

    $linguise_options['language_default'] = $language_default;
    $linguise_options['languages_enabled'] = $translate_languages;

    LinguiseHelper::updateLinguiseOptions($linguise_options);
}

$options = LinguiseHelper::getOptions(true);
$languages_content = file_get_contents(JPATH_SITE . '/modules/mod_linguise/assets/languages.json');
$languages_names = json_decode($languages_content, true);
$languages_enabled_param = isset($options['languages_enabled']) ? $options['languages_enabled'] : array();
$sort_languages = array();
foreach ($languages_enabled_param as $language) {
    if ($language === $options['language_default']) {
        continue;
    }

    if (!isset($languages_names[$language])) {
        continue;
    }

    $sort_languages[$language] = $languages_names[$language];
}

foreach ($languages_names as $lang_code => $language_value) {
    if (isset($sort_languages[$lang_code])) {
        continue;
    }
    $sort_languages[$lang_code] = $language_value;
}
$languages_names = $sort_languages;
?>
<div class="linguise-main-wrapper" style="visibility: hidden">
    <div class="linguise-left-panel-toggle">
        <i class="dashicons dashicons-leftright linguise-left-panel-toggle-icon"></i>
    </div>
    <div class="linguise-left-panel">
        <div class="linguise-top-tabs-wrapper">
            <div class="mdc-tab-bar" role="tablist">
                <div class="mdc-tab-scroller">
                    <div class="mdc-tab-scroller__scroll-area">
                        <div class="mdc-tab-scroller__scroll-content">
                            <?php
                            $i = 0;
                            foreach ($linguiseTabs as $k => $linguiseTab) :
                                ?>
                                <button class="mdc-tab <?php echo($k === 'main_settings' ? 'mdc-tab--active' : '') ?>"
                                        role="tab" aria-selected="false" data-index="<?php echo htmlspecialchars($i) ?>"
                                        id="<?php echo $k ?>"><span
                                            class="mdc-tab__content"><span class="mdc-tab__text-label"><i
                                                    class="material-icons mi wpsol-icon-menu menu-tab-icon"><?php echo htmlspecialchars($linguiseTab['icon']); ?></i><?php echo htmlspecialchars($linguiseTab['menu_name']) ?></span></span><span
                                            class="mdc-tab-indicator <?php echo($k === 'main_settings' ? 'mdc-tab-indicator--active' : '') ?>"><span
                                                class="mdc-tab-indicator__content mdc-tab-indicator__content--underline"
                                                style=""></span></span><span
                                            class="mdc-tab__ripple mdc-ripple-upgraded"></span>
                                </button>
                                <?php
                                $i++;
                            endforeach;
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <form action="" method="post">
            <div class="linguise-content-wrapper">
                <?php foreach ($linguiseTabs as $k => $linguiseTab) : ?>
                    <div class="tab-content <?php echo($k === 'main_settings' ? 'linguise-content-active' : '') ?>"
                         id="<?php echo htmlspecialchars($k); ?>">
                        <?php require_once(JPATH_ADMINISTRATOR . '/components/com_linguise/views/linguise/tmpl/' . $linguiseTab['content'] . '.php'); ?>
                    </div>
                <?php endforeach; ?>
            </div>
            <p class="submit" style="margin-top: 10px;display: inline-block;float: right; width: 100%"><input
                        type="submit"
                        name="submit"
                        id="submit"
                        class="button button-primary"
                        value="Save Settings">
            </p>
        </form>
    </div>
    <div class="linguise-right-panel">
        <?php require_once(JPATH_ADMINISTRATOR . '/components/com_linguise/views/linguise/tmpl/aside.php'); ?>
    </div>
</div>