<?php
defined('_JEXEC') or die;
?>
<div class="content">
    <?php if (!empty($errors)) : ?>
        <?php foreach ($errors as $err) { ?>
            <div class="linguise-message <?php echo htmlspecialchars('linguise-' . $err['type']); ?>">
                <?php echo htmlspecialchars($err['message']); ?>
            </div>
        <?php } ?>
    <?php endif; ?>
    <ul class="linguise-settings-option-wrap">
        <li class="linguise-settings-option full-width transparent-option">
            <label for="linguise_field_token"
                   class="linguise-setting-label label-bolder normal-line-height linguise-tippy"
                   data-tippy="<?php echo JText::_('COM_LINGUISE_API_KEY_DESCRIPTION') ?>"><?php echo JText::_('COM_LINGUISE_API_KEY_LABEL') ?><span class="material-icons">help_outline</span></label>
            <p style="width: 100%;display: inline-block;margin: 10px 0;padding-left: 15px;"><?php echo sprintf('%s and copy your domain API key to activate the translation.', '<a href="https://dashboard.linguise.com/account/register" target="_blank">Register an account</a>') ?></p>
            <div class="full-width">
                <input type="text" class="linguise-input custom-input" name="linguise_options[linguise_field_token]"
                       id="linguise_field_token"
                       value="<?php echo isset($options['linguise_field_token']) ? htmlspecialchars($options['linguise_field_token']) : '' ?>"/>
                <input type="submit"
                       class="linguise-button blue-button waves-effect waves-light small-radius small-button"
                       id="token_apply" value="Apply"/>
            </div>
        </li>
        <li class="linguise-settings-option full-width">
            <label for="original_language"
                   class="linguise-setting-label label-bolder linguise-tippy"
                   data-tippy="<?php echo JText::_('COM_LINGUISE_WEBSITE_ORIRINAL_DESCRIPTION') ?>"><?php echo JText::_('COM_LINGUISE_WEBSITE_ORIRINAL_LABEL') ?><span class="material-icons">help_outline</span></label>
            <div class="items">
                <select id="original_language" name="linguise_options[language_default]"
                        class="linguise-select original-color">
                    <?php foreach ($languages_names as $language_code => $language) : ?>
                        <option value="<?php echo htmlspecialchars($language_code); ?>" <?php echo isset($options['language_default']) ? (LinguiseHelper::selected($options['language_default'], $language_code, false)) : (''); ?>>
                            <?php // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- don't need to translate this
                            echo htmlspecialchars($language['name']); ?> (<?php echo $language_code ?>)
                        </option>
                    <?php endforeach; ?>
                </select>
                <input type="hidden" name="languages_enabled_sortable" class="languages_enabled_sortable">
            </div>
        </li>
        <li class="linguise-settings-option full-width transparent-option">
            <label for="translate_into"
                   class="linguise-setting-label label-bolder linguise-tippy"
                   data-tippy="<?php echo JText::_('COM_LINGUISE_TRANSLATE_WEBSITE_DESCRIPTION') ?>"><?php echo JText::_('COM_LINGUISE_TRANSLATE_WEBSITE_LABEL') ?><span class="material-icons">help_outline</span></label>
            <div class="items-blocks">
                <div class="block">
                    <select id="translate_into"
                            data-placeholder="Choose your language into" multiple
                            class="chosen-select languages_enabled full-on-mobile chosen-sortable" name="linguise_options[languages_enabled][]">
                        <?php foreach ($languages_names as $language_code => $language) : ?>
                            <option value="<?php echo htmlspecialchars($language_code); ?>" <?php echo isset($options['languages_enabled']) ? (LinguiseHelper::selected(in_array($language_code, $options['languages_enabled']), true, false)) : (''); ?>>
                                <?php // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- don't need to translate this
                                echo $language['name']; ?> (<?php echo $language_code; ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <input type="hidden" name="languages_enabled_sortable" class="languages_enabled_sortable">
                </div>
            </div>
            <p class="linguise_note"><?php echo sprintf('Note that adding or removing languages won\'t apply as the language configuration is made from the %s only.', '<a target="_blank" href="https://dashboard.linguise.com/"><?php echo JText::_(\'COM_LINGUISE_DASHBOARD_LABEL\') ?></a>'); ?></p>
            <p class="linguise_note"><?php echo JText::_('COM_LINGUISE_NOTE_DESCRIPTION') ?></p>
        </li>
        <li class="linguise-settings-option full-width transparent-option">
            <label class="linguise-setting-label label-bolder"><?php echo JText::_('COM_LINGUISE_HOW_TO_LOAD_LABEL') ?></label>
            <div class="items-blocks language-switcher-as">
                <div class="block">
                    <div class="left-field">
                        <a class="linguise-button waves-effect waves-light small-radius blue-button" data-tab="#menu_linguise">
                            <?php echo JText::_('COM_LINGUISE_MENU_LABEL') ?>
                        </a>
                        <a class="linguise-button waves-effect waves-light small-radius" data-tab="#shortcode">
                            <?php echo JText::_('COM_LINGUISE_LOAD_POSSITION_LABEL') ?>
                        </a>
                        <a class="linguise-button waves-effect waves-light small-radius" data-tab="#php_snippet">
                            <?php echo JText::_('COM_LINGUISE_PHP_LABEL') ?>
                        </a>
                    </div>
                    <div class="right-field">
                        <div class="switcher-as-content" id="menu_linguise">
                            <span><?php echo JText::_('COM_LINGUISE_MENU_DESCRIPTION') ?></span>
                        </div>
                        <div class="switcher-as-content" id="shortcode">
                            <span><?php echo JText::_('COM_LINGUISE_PLEASE_COPY_LABEL') ?> {loadmodule mod_linguise}</span>
                        </div>
                        <div class="switcher-as-content" id="php_snippet">
                            <span>
                                /**<br>
                                 * Get the linguise modules<br>
                                 * If you want to use a completely different login module change the value of name in your layout override.<br>
                                 */<br>
                                $linguisemodule = LinguiseModelLinguise::getLinguiseModule('mod_linguise');<br>
                                echo JModuleHelper::renderModule($linguisemodule, array('id' => 'section-box'));
                            </span>
                        </div>
                    </div>
                </div>
                <div class="clearfix"></div>
            </div>
        </li>
        <li class="linguise-settings-option transparent-option">
            <label for="id-alternate_link"
                   class="linguise-setting-label label-bolder linguise-label-inline"><?php echo JText::_('COM_LINGUISE_ALTERNATE_LINK_LABEL') ?></label>
            <div class="linguise-switch-button" style="float: left">
                <label class="switch">
                    <input type="hidden" name="linguise_options[alternate_link]" value="0">
                    <input type="checkbox" id="id-alternate_link" name="linguise_options[alternate_link]"
                           value="1" <?php echo isset($options['alternate_link']) ? (LinguiseHelper::checked($options['alternate_link'], 1)) : (''); ?> />
                    <div class="slider"></div>
                </label>
            </div>

            <p class="description" style="width: 100%; display: inline-block; padding-left: 15px; margin: 2px 0">
                <?php echo JText::_('COM_LINGUISE_ALTERNATE_LINK_DESCRIPTION') ?>
            </p>
        </li>
        <li class="linguise-settings-option full-width transparent-option">
            <label class="linguise-setting-label label-bolder linguise-tippy"
                   data-tippy="<?php echo JText::_('COM_LINGUISE_LANGUAGE_LIST_DISPLAY_DESCRIPTION') ?>"><?php echo JText::_('COM_LINGUISE_LANGUAGE_LIST_DISPLAY_LABEL') ?><span class="material-icons">help_outline</span></label>
            <div class="items-blocks language-list-display">
                <div class="display-type">
                    <ul>
                        <?php foreach (array('side_by_side' => JText::_('COM_LINGUISE_SIDE_BY_SIDE_LABEL'), 'dropdown' => JText::_('COM_LINGUISE_DROPDOWN_LABEL'), 'popup' => JText::_('COM_LINGUISE_POPUP_LABEL')) as $key => $value) : ?>
                            <li>
                                <input type="radio" class="flag_display_type" id="id-<?php echo htmlspecialchars($key) ?>"
                                       name="linguise_options[flag_display_type]"
                                       value="<?php echo htmlspecialchars($key) ?>" <?php LinguiseHelper::checked($options['flag_display_type'], $key) ?>>
                                <label for="id-<?php echo htmlspecialchars($key) ?>"><?php echo htmlspecialchars($value) ?></label>
                            </li>
                        <?php endforeach; ?>
                        <li>
                            <select name="linguise_options[display_position]" class="linguise-select full-on-mobile">
                                <?php
                                $positions = array(
                                    'no' => JText::_('COM_LINGUISE_NO_LABEL'),
                                    'top_left' => JText::_('COM_LINGUISE_TOP_LEFT_LABEL'),
                                    'top_left_no_scroll' => JText::_('COM_LINGUISE_TOP_LEFT_NO_SCROLL_LABEL'),
                                    'top_right' => JText::_('COM_LINGUISE_TOP_RIGHT_LABEL'),
                                    'top_right_no_scroll' => JText::_('COM_LINGUISE_TOP_RIGHT_NO_SCROLL_LABEL'),
                                    'bottom_left' => JText::_('COM_LINGUISE_BOTTOM_LEFT_LABEL'),
                                    'bottom_left_no_scroll' => JText::_('COM_LINGUISE_BOTTOM_LEFT_NO_SCROLL_LABEL'),
                                    'bottom_right' => JText::_('COM_LINGUISE_BOTTOM_RIGHT_LABEL'),
                                    'bottom_right_no_scroll' => JText::_('COM_LINGUISE_BOTTOM_RIGHT_NO_SCROLL_LABEL')
                                );
                                foreach ($positions as $key => $value) :
                                    ?>
                                    <option <?php LinguiseHelper::selected($options['display_position'], $key) ?>
                                            value="<?php echo htmlspecialchars($key) ?>">
                                        <?php echo htmlspecialchars($value) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </li>
                    </ul>
                </div>
                <div class="flag-name full-width">
                    <ul>
                        <li>
                            <div class="linguise-switch-button">
                                <label class="switch" style="margin: 2px  10px">
                                    <input type="hidden" name="linguise_options[enable_flag]" value="0">
                                    <input type="checkbox" id="id-enable_flag" name="linguise_options[enable_flag]"
                                           class="enable_flag"
                                           value="1" <?php echo isset($options['enable_flag']) ? (LinguiseHelper::checked($options['enable_flag'], 1)) : (''); ?> />
                                    <div class="slider"></div>
                                </label>
                                <label for="id-enable_flag"><?php echo JText::_('COM_LINGUISE_FLAG_LABEL') ?></label>
                            </div>
                        </li>

                        <li>
                            <div class="linguise-switch-button">
                                <label class="switch" style="margin: 2px  10px">
                                    <input type="hidden" name="linguise_options[enable_language_name]" value="0">
                                    <input type="checkbox" id="id-enable_language_name"
                                           name="linguise_options[enable_language_name]" class="enable_language_name"
                                           value="1" <?php echo isset($options['enable_language_name']) ? (LinguiseHelper::checked($options['enable_language_name'], 1)) : (''); ?> />
                                    <div class="slider"></div>
                                </label>
                                <label for="id-language_name"><?php echo JText::_('COM_LINGUISE_LANGUAGE_NAME_LABEL') ?></label>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </li>

        <li class="linguise-settings-option width-50">
            <label for="language_name_display" class="linguise-setting-label label-bolder linguise-tippy"
                   data-tippy="<?php echo JText::_('COM_LINGUISE_LANGUAGE_NAME_DISPLAY_DESCRIPTION') ?>"><?php echo JText::_('COM_LINGUISE_LANGUAGE_NAME_DISPLAY') ?><span class="material-icons">help_outline</span></label>
            <div class="items">
                <select name="linguise_options[language_name_display]"
                        class="linguise-select right-select original-color language_name_display">
                    <option value="en" <?php echo isset($options['language_name_display']) ? (LinguiseHelper::selected($options['language_name_display'], 'en', false)) : (''); ?>><?php echo JText::_('COM_LINGUISE_OPTION_LANGUAGE_NAME_DISPLAY_ENGLISH') ?></option>
                    <option value="native" <?php echo isset($options['language_name_display']) ? (LinguiseHelper::selected($options['language_name_display'], 'native', false)) : (''); ?>><?php echo JText::_('COM_LINGUISE_OPTION_LANGUAGE_NAME_DISPLAY_NATIVE') ?></option>
                </select>
            </div>
        </li>

        <li class="linguise-settings-option width-50 right-float">
            <label for="flag_shape" class="linguise-setting-label label-bolder linguise-label-inline linguise-tippy" data-tippy="<?php echo JText::_('COM_LINGUISE_FLAG_SHAPE_LABEL_DESCRIPTION') ?>"><?php echo JText::_('COM_LINGUISE_FLAG_SHAPE_LABEL') ?><span class="material-icons">help_outline</span></label>
            <div class="items">
                <select name="linguise_options[flag_shape]"
                        class="linguise-select right-select original-color flag_shape">
                    <option value="rounded" <?php echo isset($options['flag_shape']) ? (LinguiseHelper::selected($options['flag_shape'], 'rounded', false)) : (''); ?>><?php echo JText::_('COM_LINGUISE_OPTION_FLAG_SHAPE_ROUNDED_ALL') ?></option>
                    <option value="rectangular" <?php echo isset($options['flag_shape']) ? (LinguiseHelper::selected($options['flag_shape'], 'rectangular', false)) : (''); ?>><?php echo JText::_('COM_LINGUISE_OPTION_FLAG_SHAPE_RECTANGULAR_ALL') ?></option>
                </select>
            </div>
        </li>

        <li class="linguise-settings-option width-50">
            <label for="id-flag_border_radius"
                   class="linguise-setting-label label-bolder linguise-label-inline linguise-tippy" data-tippy="<?php echo JText::_('COM_LINGUISE_FLAG_RADIUS_DESCRIPTION') ?>"><?php echo JText::_('COM_LINGUISE_FLAG_RADIUS_LABEL') ?><span class="material-icons">help_outline</span></label>
            <input type="number" name="linguise_options[flag_border_radius]" class="flag_border_radius"
                   value="<?php echo (int)$options['flag_border_radius'] ?>" style="margin: 10px 15px; width: 100px; float: right">
        </li>

        <li class="linguise-settings-option width-50 right-float">
            <label for="id-flag_width"
                   class="linguise-setting-label label-bolder linguise-label-inline linguise-tippy" data-tippy="<?php echo JText::_('COM_LINGUISE_FLAG_SIZE_DESCRIPTION') ?>"><?php echo JText::_('COM_LINGUISE_FLAG_SIZE_LABEL') ?><span class="material-icons">help_outline</span></label>
            <input type="number" name="linguise_options[flag_width]" class="flag_width"
                   value="<?php echo (int)$options['flag_width'] ?>" style="margin: 10px 15px; width: 100px; float: right">
        </li>

        <li class="linguise-settings-option width-50">
            <label for="language_name_color" class="linguise-setting-label label-bolder linguise-label-inline linguise-tippy" data-tippy="<?php echo JText::_('COM_LINGUISE_LANGUAGE_NAME_COLOR_DESCRIPTION') ?>"><?php echo JText::_('COM_LINGUISE_LANGUAGE_NAME_COLOR_LABEL') ?><span class="material-icons">help_outline</span></label>
            <div class="items">
                <input type="text" name="linguise_options[language_name_color]" value="<?php echo htmlspecialchars($options['language_name_color']) ?>" class="language_name_color minicolors linguise-color-field" data-default-color="#222" />
            </div>
        </li>

        <li class="linguise-settings-option width-50 right-float">
            <label for="language_name_hover_color" class="linguise-setting-label label-bolder linguise-label-inline linguise-tippy" data-tippy="<?php echo JText::_('COM_LINGUISE_LANGUAGE_HOVER_NAME_COLOR_DESCRIPTION') ?>"><?php echo JText::_('COM_LINGUISE_LANGUAGE_NAME_HOVER_COLOR_LABEL') ?><span class="material-icons">help_outline</span></label>
            <div class="items">
                <input type="text" name="linguise_options[language_name_hover_color]" value="<?php echo htmlspecialchars($options['language_name_hover_color']) ?>" class="language_name_hover_color minicolors linguise-color-field" data-default-color="#222" />
            </div>
        </li>

        <li class="linguise-settings-option width-50">
            <label for="language_name_color" class="linguise-setting-label label-bolder full-width linguise-tippy" data-tippy="Color and shadow size for your language flags">Flag box shadow<span class="material-icons">help_outline</span></label>
            <div class="flag_shadow_element full-width">
                <p>
                    <label><?php echo JText::_('COM_LINGUISE_FLAG_SHADOW_H_LABEL') ?></label>
                    <input type="range" min="-50" max="50" value="<?php echo htmlspecialchars($options['flag_shadow_h']) ?>" step="1" class="flag_shadow_h" onchange="window.linguiseUpdateTextInput(this.value, 'flag_shadow_h');">
                    <input type="number" id="flag_shadow_h" name="linguise_options[flag_shadow_h]" onchange="window.linguiseUpdateSliderInput(this.value, 'flag_shadow_h');" value="<?php echo htmlspecialchars($options['flag_shadow_h']) ?>">
                </p>
                <p>
                    <label><?php echo JText::_('COM_LINGUISE_FLAG_SHADOW_V_LABEL') ?></label>
                    <input type="range" min="-50" max="50" value="<?php echo htmlspecialchars($options['flag_shadow_v']) ?>" step="1" class="flag_shadow_v" onchange="window.linguiseUpdateTextInput(this.value, 'flag_shadow_v');">
                    <input type="number" id="flag_shadow_v" name="linguise_options[flag_shadow_v]" onchange="window.linguiseUpdateSliderInput(this.value, 'flag_shadow_v');" value="<?php echo htmlspecialchars($options['flag_shadow_v']) ?>">
                </p>
                <p>
                    <label><?php echo JText::_('COM_LINGUISE_FLAG_SHADOW_BLUE_LABEL') ?></label>
                    <input type="range" min="0" max="50" value="<?php echo htmlspecialchars($options['flag_shadow_blur']) ?>" step="1" class="flag_shadow_blur" onchange="window.linguiseUpdateTextInput(this.value, 'flag_shadow_blur');">
                    <input type="number" id="flag_shadow_blur" name="linguise_options[flag_shadow_blur]" onchange="window.linguiseUpdateSliderInput(this.value, 'flag_shadow_blur');" value="<?php echo htmlspecialchars($options['flag_shadow_blur']) ?>">
                </p>
                <p>
                    <label><?php echo JText::_('COM_LINGUISE_FLAG_SHADOW_SPREAD_LABEL') ?></label>
                    <input type="range" min="0" max="50" value="<?php echo htmlspecialchars($options['flag_shadow_spread']) ?>" step="1" class="flag_shadow_spread" onchange="window.linguiseUpdateTextInput(this.value, 'flag_shadow_spread');">
                    <input type="number" id="flag_shadow_spread" name="linguise_options[flag_shadow_spread]" onchange="window.linguiseUpdateSliderInput(this.value, 'flag_shadow_spread');" value="<?php echo htmlspecialchars($options['flag_shadow_spread']) ?>">
                </p>
                <p>
                    <label><?php echo JText::_('COM_LINGUISE_FLAG_SHADOW_COLOR_LABEL') ?></label>
                    <input type="text" name="linguise_options[flag_shadow_color]" value="<?php echo htmlspecialchars($options['flag_shadow_color']) ?>" class="flag_shadow_color minicolors linguise-color-field" data-default-color="#bfbfbf" />
                </p>
            </div>
        </li>

        <li class="linguise-settings-option width-50 right-float">
            <label for="language_name_color" class="linguise-setting-label label-bolder full-width linguise-tippy" data-tippy="Color and shadow size for your language flags on mouse hover">Flag box shadow on hover<span class="material-icons">help_outline</span></label>
            <div class="flag_shadow_element full-width">
                <p>
                    <label><?php echo JText::_('COM_LINGUISE_FLAG_SHADOW_H_LABEL') ?></label>
                    <input type="range" min="-50" max="50" value="<?php echo htmlspecialchars($options['flag_hover_shadow_h']) ?>" step="1" class="flag_hover_shadow_h" onchange="window.linguiseUpdateTextInput(this.value, 'flag_hover_shadow_h');">
                    <input type="number" id="flag_hover_shadow_h" name="linguise_options[flag_hover_shadow_h]" onchange="window.linguiseUpdateSliderInput(this.value, 'flag_hover_shadow_h');" value="<?php echo htmlspecialchars($options['flag_hover_shadow_h']) ?>">
                </p>
                <p>
                    <label><?php echo JText::_('COM_LINGUISE_FLAG_SHADOW_V_LABEL') ?></label>
                    <input type="range" min="-50" max="50" value="<?php echo htmlspecialchars($options['flag_hover_shadow_v']) ?>" step="1" class="flag_hover_shadow_v" onchange="window.linguiseUpdateTextInput(this.value, 'flag_hover_shadow_v');">
                    <input type="number" id="flag_hover_shadow_v" name="linguise_options[flag_hover_shadow_v]" onchange="window.linguiseUpdateSliderInput(this.value, 'flag_hover_shadow_v');" value="<?php echo htmlspecialchars($options['flag_hover_shadow_v']) ?>">
                </p>
                <p>
                    <label><?php echo JText::_('COM_LINGUISE_FLAG_SHADOW_BLUE_LABEL') ?></label>
                    <input type="range" min="0" max="50" value="<?php echo htmlspecialchars($options['flag_hover_shadow_blur']) ?>" step="1" class="flag_hover_shadow_blur" onchange="window.linguiseUpdateTextInput(this.value, 'flag_hover_shadow_blur');">
                    <input type="number" id="flag_hover_shadow_blur" name="linguise_options[flag_hover_shadow_blur]" onchange="window.linguiseUpdateSliderInput(this.value, 'flag_hover_shadow_blur');" value="<?php echo htmlspecialchars($options['flag_hover_shadow_blur']) ?>">
                </p>
                <p>
                    <label><?php echo JText::_('COM_LINGUISE_FLAG_SHADOW_SPREAD_LABEL') ?></label>
                    <input type="range" min="0" max="50" value="<?php echo htmlspecialchars($options['flag_hover_shadow_spread']) ?>" step="1" class="flag_hover_shadow_spread" onchange="window.linguiseUpdateTextInput(this.value, 'flag_hover_shadow_spread');">
                    <input type="number" id="flag_hover_shadow_spread" name="linguise_options[flag_hover_shadow_spread]" onchange="window.linguiseUpdateSliderInput(this.value, 'flag_hover_shadow_spread');" value="<?php echo htmlspecialchars($options['flag_hover_shadow_spread']) ?>">
                </p>
                <p>
                    <label><?php echo JText::_('COM_LINGUISE_FLAG_SHADOW_COLOR_LABEL') ?></label>
                    <input type="text" name="linguise_options[flag_hover_shadow_color]" value="<?php echo htmlspecialchars($options['flag_hover_shadow_color']) ?>" class="flag_hover_shadow_color minicolors linguise-color-field" data-default-color="#bfbfbf" />
                </p>
            </div>
        </li>
    </ul>
</div>